<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElement.php,v 1.12 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڥ饹
 */
require_once 'SyL_Validation.php';

/**
 * եǤδ쥯饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElement.php,v 1.12 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElement
{
    /**
     * եHTMLη
     *
     * @access private
     * @var string
     */
    var $type = '';
    /**
     * եHTML̾
     *
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * եɽ̾
     *
     * @access private
     * @var string
     */
    var $display_name = '';
    /**
     * եǤ
     *
     * @access private
     * @var string
     */
    var $value = '';
    /**
     * եHTMLɲ°
     *
     * @access private
     * @var string
     */
    var $attributes = array();
    /**
     * ե
     * radio, select, checkboxΤ
     *
     * @access private
     * @var array
     */
    var $options = array();
    /**
     * ɤ߼ѥե饰
     *
     * @access private
     * @var bool
     */
    var $read_only = false;
    /**
     * 顼å
     * 顼å''ξϡ顼̵
     *
     * @access private
     * @var string
     */
    var $error_message = '';
    /**
     * ڥ롼ץ֥
     *
     * @access private
     * @var object
     */
    var $validators = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string եHTMLη
     * @param string եHTML̾
     * @param string եɽ̾
     * @param array ե°
     */
    function SyL_FormElement($type, $name, $display_name, $attributes=array())
    {
        $this->type         = strtolower($type);
        $this->name         = $name;
        $this->display_name = $display_name;
        $this->attributes   = $attributes;
    }

    /**
     * ̥եǥ֥Ȥμ
     *
     * @access public
     * @param string եǥ
     * @param string ե̾
     * @param string եɽ̾
     * @param mixed ꥯȽ
     * @param array եǤradio, select, checkboxξΤߡ
     * @param mixed եǤ͡checkboxξ󡢤ʳstring
     * @param array եǤɲ°
     */
    function &create($type, $name, $display_name, $value=null, $options=array(), $attributes=array())
    {
        $class_name = 'SyL_FormElement' . ucfirst($type);
        include_once dirname(__FILE__) . "/FormElement/{$class_name}.php";
        $element =& new $class_name($type, $name, $display_name, $attributes);
        $element->setValue($value);
        $element->setOptions($options);
        return $element;
    }

    /**
     * ɲåץ
     *
     * @access protected
     * @param array եǤradio, select, checkboxξΤߡ
     */
    function setOptions($options=array())
    {
        if (is_array($options)) {
            $this->options = $options;
        }
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * ̾ʣξ祪С饤ɡ
     *
     * @access public
     * @return string ̾
     */
    function getNames()
    {
        return $this->getName();
    }

    /**
     * ե̾
     *
     * @access public
     * @return string ե̾
     */
    function getType()
    {
        return $this->type;
    }

    /**
     * եɽ̾
     *
     * @access public
     * @return string ̾
     */
    function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * ͤ򥻥åȤ
     *
     * @access public
     * @param mixed 
     */
    function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * ͤ
     *
     * @access public
     * @return string ̾
     */
    function getValue()
    {
        return $this->value;
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * °򥻥å
     *
     * @access public
     * @param string °
     * @param string °̾
     */
    function setAttribute($value, $name=null)
    {
        if ($name) {
            $name = strtolower($name);
            $this->attributes[$name] = $value;
        } else {
            $this->attributes[] = $value;
        }
    }

    /**
     * ¾°
     *
     * @access public
     * @return string ¾°
     */
    function getAttributes()
    {
        $attributes = array();
        foreach ($this->attributes as $k => $v) {
            $attributes[] = is_int($k) ? $this->encode($v) : ($k . '="' . $this->encode($v) . '"');
        }
        return implode(' ', $attributes);
    }

    /**
     * եɽȽե饰򥻥å
     *
     * @access public
     * @param bool եɽȽե饰
     */
    function setReadOnly($read_only)
    {
        $this->read_only = ($read_only === true);
    }

    /**
     * ɬܥå¸Ƚ
     * ڥ롼ץ֥Ȥ򥻥åȤƤ¹Ԥ
     *
     * @access public
     * @return bool true: ɬܥåꡢfalse: ɬܥå̵
     */
    function isRequire()
    {
        return is_object($this->validators) ? $this->validators->isRequire() : false;
    }

    /**
     * եǤɽȽ
     *
     * @access public
     * @param bool եǤɽȽ
     */
    function isReadOnly()
    {
        return $this->read_only;
    }

    /**
     * եHTML
     * ɤ߼ѤˤʤäƤ뤫ǡҥ饹Υ᥽åɤƤʬ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtml()
    {
        if ($this->read_only) {
            return $this->getHtmlView();
        } else {
            return $this->getHtmlTag();
        }
    }

    /**
     * եHTMLϡɽ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
    }

    /**
     * եǤhiddenǽ
     *
     * @access public
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtmlHidden($name=null, $value=null)
    {
        if (($name === null) || ($value === null)) {
            $name  = $this->name;
            $value = $this->value;
        }
        return '<input type="hidden" name="'  . $name  . '" value="' . $this->encode($value) . '" />';
    }

    /**
     * HTML󥳡ɤԤ
     *
     * @access public
     * @param string HTML󥳡ʸ
     * @return string HTML󥳡ɸʸ
     */
    function encode($value)
    {
        return htmlspecialchars($value);
    }

    /**
     * ڥ롼ץ֥Ȥ򥻥å
     *
     * @access public
     * @param object ڥ롼ץ֥
     */
    function setValidators(&$validators)
    {
        if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
            $this->validators = unserialize(serialize($validators));
        } else {
            $this->validators = $validators;
        }
    }

    /**
     * ڤ¹Ԥ
     * ڥ롼ץ֥Ȥʤϡtrue
     *
     * @access public
     * @return bool true: 顼̵false: 顼
     */
    function validate()
    {
        if (!is_object($this->validators)) {
            return true;
        }

        if (!$this->validators->execute($this->getValue(), $this->getDisplayName())) {
            $this->error_message = $this->validators->getErrorMessage();
            return false;
        } else {
            return true;
        }
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @param string ե̾
     * @return string JavaScriptϥå
     */
    function getJs($formname)
    {
        if (is_object($this->validators)) {
            $element = $this->getName();
            $func    = "check_{$formname}_{$element}(form, errors)";
            $js      = $this->validators->getJs($this->getDisplayName());
            $js = <<< JAVASCRIPT_CODE
function {$func} {
  var validation    = new SyL_Validation(form);
  var element_name  = "{$element}";
  var error_message = "";

{$js}

  if (error_message) {
    switch (typeof(errors)) {
    case 'object':
      errors.setErrorMessage(element_name, error_message);
      break;
    case 'string':
      document.getElementById(errors).innerHTML = error_message;
      break;
    }
  }
}
JAVASCRIPT_CODE;
            return array($func, $js);
        } else {
            return array();
        }
    }
}

?>
