<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.1 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PHPեɥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.1 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Loader
{
    /**
     * 饤֥ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return mixed include_once
     */
    function lib($path)
    {
        $path = call_user_func(array(__CLASS__, 'correctPath'), $path);
        // ץꥱ饤֥ǥ쥯ȥ
        $base1 = SYL_PROJECT_LIB_DIR . $path;
        if (is_file($base1)) {
            return call_user_func(array(__CLASS__, 'load'), $base1);
        }
        // ɸ饤֥ǥ쥯ȥ
        $base2 = SYL_INCLUDE_DIR . "/lib" . $path;
        if (is_file($base2)) {
            return call_user_func(array(__CLASS__, 'load'), $base2);
        }

        trigger_error("[SyL error] file not found ({$base1} or {$base2})", E_USER_ERROR);
    }

    /**
     * ե졼ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return mixed include_once
     */
    function fw($path)
    {
        $path = call_user_func(array(__CLASS__, 'correctPath'), $path);
        $base = SYL_INCLUDE_DIR . "/framework" . $path;
        if (is_file($base)) {
            return call_user_func(array(__CLASS__, 'load'), $base);
        }

        trigger_error("[SyL error] file not found ({$base})", E_USER_ERROR);
    }

    /**
     * ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return mixed include_once
     */
    function load($path)
    {
        if (is_readable($path)) {
            return include_once $path;
        } else {
            trigger_error("[SyL error] file not readable ({$path})", E_USER_ERROR);
        }
    }

    /**
     * ѥ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return string ɥե
     */
    function correctPath($path)
    {
        return '/' . str_replace('.', '/', $path) . '.php';
    }
}

?>
