<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.3 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptϥե졼饹
 */
require_once 'SyL_ContextJs.php';

/**
 * WEBץꥱե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.3 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ContextWeb extends SyL_ContextJs
{
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';

    /**
     * ѥ
     * 
     * @access private
     * @param string ѥ
     * @return string ѥ
     */
    function convertPath($path, $is_dir_path=false)
    {
        if ($is_dir_path && !preg_match('/(\\\\|\/)$/', $path)) {
            $path .= '/';
        } else if (!$is_dir_path) {
            while (preg_match('/^(\\\\|\/)/', $path)) {
                $path = substr($path, 1);
            }
        }
        return $path;
    }

    /**
     * ɥե򥻥å
     *
     * ɥե̾ꤷʤϡContent-Disposition: inline ˤʤ
     * 
     * @access public
     * @param string ɥեѥ
     * @param string ɥե̾
     * @param string ƥĥ
     */
    function setDownloadFile($file, $filename='', $type='application/octet-stream')
    {
        $data = file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Download file ($file)", E_USER_ERROR);
        }
        $this->setDownloadData($data, $filename, $type);
    }

    /**
     * ɥǡ򥻥å
     * 
     * ɥե̾ꤷʤϡContent-Disposition: inline ˤʤ
     *
     * @access public
     * @param string ɥեѥ
     * @param string ɥե̾
     * @param string ƥĥ
     */
    function setDownloadData($data, $filename='', $type='application/octet-stream')
    {
        $this->setViewType('download');
        $this->setParameter('_download_name', $filename);
        $this->setParameter('_download_type', $type);
        $this->setParameter('_download_data', $data);
    }

    /**
     * ϲե򥻥å
     *
     * @access public
     * @param string եѥ
     * @param string ƥĥ
     */
    function setDisplayImageFile($file, $type='')
    {
        if (!$type) {
            $size = getimagesize($file);
            if (!$size || !isset($size['mime'])) {
                trigger_error("[SyL error] Image mime unable to get from getimagesize function ($file)", E_USER_ERROR);
            }
            $type = $size['mime'];
        }
        $data = @file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Image file ($file)", E_USER_ERROR);
        }
        $this->setDisplayImageData($data, $type);
    }

    /**
     * ϲǡ򥻥å
     *
     * @access public
     * @param string Хʥǡ
     * @param string ƥĥ
     */
    function setDisplayImageData($data, $type='')
    {
        $this->setViewType('image');
        $this->setParameter('_image_type',  $type);
        $this->setParameter('_image_data',  $data);
    }

    /**
     * XML֥ȡSyL_XmlWriterˤ򥻥å
     *
     * @access public
     * @param object XML֥
     * @param string ƥĥ
     */
    function setDisplayXml($rss_object, $type='text/xml')
    {
        $this->setViewType('xml');
        $this->setParameter('_xml_type',    $type);
        $this->setParameter('_xml_object',  $rss_object);
    }

    /**
     * RSS֥ȡSyL_XmlRssWriterˤ򥻥å
     *
     * @access public
     * @param object RSS֥
     * @param string ƥĥ
     */
    function setDisplayRss($rss_object, $type='text/xml')
    {
        $this->setViewType('rss');
        $this->setParameter('_rss_type',    $type);
        $this->setParameter('_rss_object',  $rss_object);
    }

    /**
     * 쥯URL򥻥å
     *
     * @access public
     * @param string 쥯URL
     */
    function setRedirectUrl($url)
    {
        $this->setViewType('redirect');
        $this->setParameter('_redirect_url', $url);
    }

    /**
     * ޥӥ塼饹
     *
     * @access public
     * @return string ޥӥ塼饹
     */
    function getCustomizedViewClass()
    {
        return $this->view_parameters['customizedviewclass'];
    }

    /**
     * ޥӥ塼ե
     *
     * @access public
     * @return string ޥӥ塼ե
     */
    function getCustomizedViewFile()
    {
        return $this->view_parameters['customizedviewfile'];
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->convertPath($this->controller->getTemplateDir(), true);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->convertPath($this->template_file, false);

        // ǥХå - ƥץ졼Ȥξ
        SyL_Loggers::debug("[Context] template info  dir: {$template_dir} file: {$template_file}");

        // ƥץ졼ȥե¸ߥå
        if (!is_file($template_dir . $template_file)) {
            SyL_Response::redirect404();
        }
        return $template_file;
    }
}

?>
