<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.1 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹ߥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.1 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FileReader extends SyL_File
{
    /**
     * ե륪ץ⡼
     * 
     * @access protected
     * @var string
     */
    var $mode = 'rb';
    /**
     * CSVСѰ켡ե̾
     * 
     * @access private
     * @var string
     */
    var $tmp_name = '';

    /**
     * ե򳫤
     *
     * @access public
     * @param string ץ⡼
     */
    function open()
    {
        if ($this->csv && $this->encode_script) {
            $internal_encoding = mb_internal_encoding();
            if (strtolower($this->encode_script) != strtolower($internal_encoding)) {
                $data = file_get_contents($this->resource_name);
                $data = mb_convert_encoding($data, $internal_encoding, $this->encode_script);

                $this->tmp_name = tempnam('/tmp', 'syl_file_');
                $writer =& SyL_File::factory('w', $this->tmp_name);
                $writer->process($data);

                $this->resource_name = $this->tmp_name;
                $this->encode_file   = $internal_encoding;
            }
        }
        parent::open();
    }

    /**
     * ե뤫ɤ߹
     *
     * @access public
     * @return string ϥǡ or bool(false) ɤ߹߽λ
     */
    function read()
    {
        if ($this->csv) {
            if ($this->csv_enclosure) {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter, $this->csv_enclosure);
            } else {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter);
            }
            return is_array($data) ? array_map(array(&$this, 'convertEncode'), $data) : $data;
        } else {
            $data = fgets($this->fp);
            return is_string($data) ? $this->convertEncode($data) : $data;
        }
    }

    /**
     * ե˽Ϥ
     *
     * @access public
     * @param string å
     */
    function write($message)
    {
        trigger_error("[SyL error] Unable to write method in " . get_class($this) . " class", E_USER_ERROR);
    }

    /**
     * եĤ
     *
     * @access public
     */
    function close()
    {
        parent::close();

        // CSVѰե
        if (file_exists($this->tmp_name)) {
            unlink($this->tmp_name);
        }
    }

    /**
     * եˤƤɤ߹
     *
     * @access public
     * @return string եΥǡ
     */
    function process()
    {
        if ($this->csv) {
            $data[] = array();
            $this->open();
            while ($tmp = $this->read()) {
                $data[] = $tmp;
            }
            $this->close();
            return $data;
        } else {
            $data = file_get_contents($this->resource_name);
            return is_string($data) ? $this->convertEncode($data) : $data;
        }
    }

    /**
     * ϥ󥳡ǥ󥰤Ѵ
     *
     * @access protected
     * @param string 󥳡ǥѴΥեΥǡ
     * @return string 󥳡ǥѴΥեΥǡ
     */
    function convertEncode($data)
    {
        if ($this->encode_script) {
            return ($this->encode_file)
                 ? mb_convert_encoding($data, $this->encode_script, $this->encode_file)
                 : mb_convert_encoding($data, $this->encode_script);
        } else {
            return $data;
        }
    }
}

?>
