<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: adm.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

error_reporting(E_ALL);

// ʃvWFNg̐ݒt@C擾邽߂̏
$is_project_dir = false;
$define_config  = '';
foreach ($argv as $arg) {
    if ($is_project_dir) {
        $define_config = $arg . '/config/defines.xml';
        break;
    }
    $is_project_dir = ($arg == '-d');
}

if ((array_search('-v', $argv) === false) &&
    (array_search('-h', $argv) === false) &&
    (array_search('--version', $argv) === false) &&
    (array_search('--help',    $argv) === false)) {
    if (!$define_config) {
        echo "[SyL error] project directory not found.\nTry `php {$argv[0]} --help' for more information.\n";
        exit;
    } else if (!is_file($define_config)) {
        echo "[SyL error] invalid config file ({$define_config})\nTry `php {$argv[0]} --help' for more information.\n";
        exit;
    }
}

$syl_dir = dirname(dirname(__FILE__));

require_once $syl_dir . '/SyL.php';

$config = array(
  'action_key' => 'action',
  'webapp_dir' => $syl_dir . '/opt/adm',
  'app_name'   => 'generate',
  'define'     => $define_config,
  'debug'      => SYL_LOG_DEBUG
);

$controller =& SyL_Controller::getController($config);
$controller->stream();

?>
