<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextJs.php,v 1.6 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Request.php';

/**
 * JavaScriptϥե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextJs.php,v 1.6 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ContextJs extends SyL_Context
{
    /**
     * ꥯȥ֥
     * 
     * @access private
     * @var object
     */
    var $request = null;

    /**
     * ꥯȥ֥Ȥ
     *
     * @access public
     * @return object ꥯȥ֥
     */
    function &getRequest()
    {
        if ($this->request == null) {
            $this->request =& SyL_Request::singleton();
        }
        return $this->request;
    }

    /**
     * ĶѿGETꥯȤȽꤹ
     *
     * @access public
     * @return bool true: GETꥯȡfalse: GETꥯȰʳ
     */
    function isGet()
    {
        return (isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET'));
    }

    /**
     * ĶѿPOSTꥯȤȽꤹ
     *
     * @access public
     * @return bool true: POSTꥯȡfalse: POSTꥯȰʳ
     */
    function isPost()
    {
        return (isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'POST'));
    }

    /**
     * ĶѿSSLȽꤹ
     *
     * @access public
     * @return bool true: POSTꥯȡfalse: POSTꥯȰʳ
     */
    function isSsl()
    {
        return (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on'));
    }

    /**
     * Ķѿ饵С̾
     *
     * @access public
     * @return string С̾
     */
    function getServerName()
    {
        if (isset($_SERVER['HTTP_HOST'])) {
            return $_SERVER['HTTP_HOST'];
        } else if (isset($_SERVER['SERVER_NAME'])) {
            if (isset($_SERVER['SERVER_PORT']) && ($_SERVER['SERVER_PORT'] != '80')) {
                return $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'];
            } else {
                return $_SERVER['SERVER_NAME'];
            }
        } else {
            return null;
        }
    }

    /**
     * ĶѿꥯURLSCRIPT_NAMEˤ
     *
     * @access public
     * @return string SCRIPT_NAME
     */
    function getUrl()
    {
        return isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : null;
    }

    /**
     * ĶѿꥯURLPHP_SELFˤ
     *
     * @access public
     * @return string SCRIPT_NAME
     */
    function getUrlContainsPathinfo()
    {
        return isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : null;
    }

    /**
     * ĶѿPATHINFO
     *
     * @access public
     * @return string PATHINFO
     */
    function getPathinfo()
    {
        return isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : null;
    }

}

?>
