<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableRelations.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLϢ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableRelations.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlTableRelations
{
    /**
     * 
     * 
     * @access private
     * @var array
     */
    var $wheres = array();

    /**
     * SQLʸ
     *
     * @access public
     * @return string SQLʸ
     */
    function getWhere()
    {
        $wheres = array();
        $first  = true;
        $or     = false;
        foreach ($this->wheres as $where) {
            $wheres[] = "{$where[0]} {$where[2]} {$where[1]}";
            if ($first) {
                $first = false;
            } else {
                $max = count($wheres) - 1;
                if ($where[3] == 'OR') {
                    if (!$or) {
                        $wheres[$max-1] = '(' . $wheres[$max-1];
                        $or = true;
                    }
                } else {
                    if ($or) {
                        $wheres[$max-1] = $wheres[$max-1] . ')';
                        $or = false;
                    }
                }
                $wheres[$max] = ' ' . $where[3] . ' ' . $wheres[$max];
            }
        }

        return implode('', $wheres);
    }

    /**
     * whereӡ
     *
     * @access public
     * @param object ơ֥륪֥1
     * @param string ơ֥륪֥1δϢ̾
     * @param object ơ֥륪֥2
     * @param string ơ֥륪֥2δϢ̾
     * @param bool true: =, false: <>
     * @param bool true: AND, false: OR
     */
    function addEqual($table1, $column1, $table2, $column2, $equal=true, $and=true)
    {
        $op = ($equal) ? '=' : '<>';
        $column1 = $table1->getAliasName() . '.' . $column1;
        $column2 = $table2->getAliasName() . '.' . $column2;
        $this->add($column1, $column2, $op, $and);
    }

    /**
     * where
     *
     * @access private
     * @param string ̾
     * @param mixed 
     * @param string 黻
     * @param bool true: AND, false: OR
     */
    function add($name, $value, $operator, $and)
    {
        $operator = strtoupper($operator);
        $logical  = $and ? 'AND' : 'OR';
        switch ($operator) {
        case '=':
        case '!=':
        case '<>':
            break;
        default:
            trigger_error("[SyL error] Not supported operator ({$operator})", E_USER_ERROR);
        }

        $this->wheres[] = array($name, $value, $operator, $logical);
    }
}

?>
