<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Action.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Action.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Action
{
    var $c_action; // 󥸥

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Action()
    {
    }

    /**
     * 
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $project_dir  = $data->get('d');
        $app_name     = $data->get('w');
        $action_files = $data->get('a');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        $app_dir = $project_dir . 'app/' . $app_name . '/';

        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_dir = $app_dir . 'actions/';
        $cnt = count($action_files);
        if ($cnt == 0) {
            trigger_error("[SyL error] Action file not found", E_USER_ERROR);
            exit;
        }

        foreach ($action_files as $action_file) {
            if (!preg_match('/^(\\\\|\/)/', $action_file)) {
                $action_file = '/' . $action_file;
            }
            if (substr($action_file, -4) != '.php') {
                $action_file .= '.php';
            }
            if (file_exists($action_dir . $action_file)) {
                trigger_error("[SyL error] Already action file exists ({$action_dir}{$action_file})", E_USER_ERROR);
                exit;
            }
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        $this->c_action->trigger($project_dir, $app_name, $action_files);
    }

}

?>
