<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowUpd.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowUpd.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowUpd extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'upd';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowUpd()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        // 祭ѥ᡼̾
        $key_name = $form->getStructConfig('key_name');
        // ѥ᡼
        $key = $data->get($key_name);
        if (($key === null) || ($key === '')) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // DB³
        $conn =& $this->getDB();
        // ADM֥Ⱥ
        $adm  =& SyL_Adm::factory($form, $conn, array($key));
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isUpd()) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // ʬ
        if ($context->isPost()) {
            // ǡ֥ȥå
            $form->registerInput($data);
            // ե๽
            $form->build();

            // ؿʤ
            if ($data->get('__adm_next')) {
                // Хǡ¹
                if ($form->validate()) {
                    // ǧ̤
                    $form->setReadOnly(true);
                }
            } else if ($data->get('__adm_exe')) {
                // Хǡ¹
                if ($form->validate()) {
                    // ¹
                    $adm->update();
                    // λ̤إ쥯
                    SyL_Response::redirect($this->getUrl('fin') . '?__adm=upd');
                }
            } else if ($data->get('__adm_prev')) {
                // ǧ̤
            }
        } else {
            // ɽ
            $result = $adm->getRecord();
            if ($result == null) {
                SyL_Response::redirect($this->getUrl('lst'));
            }
            // ¸ǡå
            $data->sets($result);
            // ǡ֥ȥå
            $form->registerInput($data);
            // ե๽
            $form->build();
        }

        // 祭ѥ᡼
        $key_value = $adm->getKeyQuery();

        // DB³λ
        $conn->closeConnection();

        // եǥǡ
        $data->set('form', $form->getResultArray());
        // 祭ѥ᡼
        $data->set('key_name',  $key_name);
        $data->set('key_value', $key_value);
        // ǧɽϢ
        $data->set('view_alert',   $form->getStructConfig('view_alert'));
        $data->set('view_confirm', $form->getStructConfig('view_confirm'));
        // ɽѥѥ᡼Ѥ
        $data->set('page', $data->get('page'));
        $data->set('sort', $data->get('sort'));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_upd', $this->getUrl('upd'));
        $data->set('url_up',  $this->getUpUrl());
        $data->set('url_dir', dirname($this->getScriptName()));
    }
}

?>
