<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationUpd.php,v 1.2 2007/08/08 12:25:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - 
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationUpd.php,v 1.2 2007/08/08 12:25:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperationUpd extends SyL_AdmOperation
{
    /**
     * 饹Υץѥƥơ֥ȴϢ
     *
     * @access public
     */
    function loadConfig()
    {
        parent::loadConfig();

        // ǡޥǡ
        $data_sources = $this->form->getDataSources();
        foreach ($data_sources as $name => $data_source) {
            // ơ֥륪֥ȼ
            $table =& $this->tables[$data_source['alias']];
            $table->addColumn($data_source['name']);
            $table->addColumn($data_source['value']);
/*
            // Ƚ
            if (isset($data_source['conditions']) && $data_source['conditions']) {
                // 索֥Ⱥ
                $conditions = $this->dao->createCondition();
                foreach ($data_source['conditions'] as $condition) {
                    $conditions = explode('.', $condition, 4);
                    $method     = array_shift($conditions);
                // 祭糧å
                $this->setConditionKey($conditions, $alias);
                // 索֥ȥå
                $table->setConditions($conditions);
*/
            // ¸options
            if (!isset($this->form->elements_config[$name]['options'])) {
                $this->form->elements_config[$name]['options'] = array();
            }
            foreach ($this->dao->select($table) as $values) {
                $column_name  = current($values);
                $column_value = next($values);
                $this->form->elements_config[$name]['options'][$column_value] = $column_name;
            }
        }
    }

    /**
     * Ԥ
     *
     * @access public
     * @return array 
     */
    function update()
    {
        $table = null;
        foreach (array_keys($this->tables) as $alias) {
            if ($alias == $this->form->getMaintenanceTable()) {
                // ơ֥륪֥ȼ
                $table =& $this->tables[$alias];
                // ǡܽ
                $table->initDataColumns();
                // Ͽǡå
                foreach ($this->form->getValues($alias) as $name => $value) {
                    $table->addColumn($name, $value);
                }
                // 索֥Ⱥ
                $conditions = $this->dao->createCondition();
                // 祭糧å
                $this->setConditionKey($conditions, $alias);
                // 索֥ȥå
                $table->setConditions($conditions);
                break;
            }
        }

        if ($table) {
            return $this->dao->update($table);
        } else {
            return false;
        }
    }
}

?>
