<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthArray.php,v 1.3 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthArray.php,v 1.3 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AuthArray extends SyL_Auth
{
    /**
     * ǧھ
     *
     * array( username => password, ... )
     * 
     * @access protected
     * @var array
     */
    var $auth_users = array(
      'test_user'  => 'test_password'
    );

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        return (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_POST[$this->username]) && isset($_POST[$this->password]));
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
         $client_username = isset($_POST[$this->username]) ? $_POST[$this->username] : '';
         $client_password = isset($_POST[$this->password]) ? $_POST[$this->password] : '';

         $server_password = '';
         if (isset($this->auth_users[$client_username])) {
             $server_password = $this->auth_users[$client_username];
         } else {
             // ǧԲ
             $client_username = '';
         }
         // ѥȽ
         return $this->isLoginPassword($client_username, $client_password, $server_password, (bool)SYL_AUTH_TYPE_PARAMETER);
    }
}

?>
