<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.18 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PATH_INFOĶѿե졼ͤ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.18 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterPathinfo extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = '.';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access protected
     * @param object ꥯȥ֥
     */
    function createActionInfo(&$data)
    {
        // PATH_INFOĶѿ
        $pathinfo = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';

        if ($pathinfo == '') {
            $this->action_method = '';
            $this->action_file   = '/' . $this->action_file_default;
        } else if (substr($pathinfo, -1) == '/') {
            $this->action_method = '';
            $this->action_file   = $pathinfo . $this->action_file_default;
        } else {
            // ĥȽ
            if ($this->url_ext && !preg_match('/^(.+)(' . preg_quote($this->url_ext) . ')$/', $pathinfo)) {
                SyL_Response::redirect404();
            }
            $pathinfo_file  = basename($pathinfo);
            $pathinfo_dir   = dirname($pathinfo);
            $pathinfo_files = explode($this->action_delimiter, $pathinfo_file, 2);

            // windowsб
            if ($pathinfo_dir == '\\') {
                $pathinfo_dir = '';
            }

            if ($pathinfo_dir != '/') {
                $pathinfo_dir .= '/';
            }

            // ƬʸѴ
            $pathinfo_dir = implode('/', array_map('ucfirst', explode('/', $pathinfo_dir)));

            if (count($pathinfo_files) == 2) {
                if (($this->action_delimiter == '.') && ($this->url_ext == ('.' . $pathinfo_files[1]))) {
                    // ᥽åɤʤ
                    $this->action_method = '';
                    $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[0]) . $this->exe_ext;
                } else {
                    $this->action_method = ucfirst($pathinfo_files[0]);
                    if (preg_match('/^(.+)(' . preg_quote($this->url_ext) . '|' . preg_quote($this->exe_ext) . ')$/', $pathinfo_files[1], $matches)) {
                        // ᥽åɤ
                        $this->action_file = $pathinfo_dir . ucfirst($matches[1]) . $this->exe_ext;
                    } else {
                        // ᥽åɤ
                        $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[1]) . $this->exe_ext;
                    }
                }
            } else {
                // ᥽åɤʤ
                $this->action_method = '';
                if (preg_match('/^(.+)(' . preg_quote($this->url_ext) . '|' . preg_quote($this->exe_ext) . ')$/', $pathinfo_files[1], $matches)) {
                    $this->action_file = $pathinfo_dir . ucfirst($matches[1]) . $this->exe_ext;
                } else {
                    $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[1]) . $this->exe_ext;
                }
            }
        }

        $action_method = null;
        // ᥽åͤѥ᡼Υ
        if (($action_method === null) && ((SYL_ROUTER_EXTRA_ACTION == '1') || (SYL_ROUTER_EXTRA_ACTION == '3'))) {
            $reg = '/^' . preg_quote(SYL_ACTION_KEY) . '_(.+)(_x|_y)?$/';
            foreach ($data->gets() as $name => $value) {
                if (preg_match($reg, $name, $matches)) {
                    $action_method = $matches[1];
                    break;
                }
            }
        }
        // ͤѥ᡼ͤ
        if (($action_method === null) && ((SYL_ROUTER_EXTRA_ACTION == '2') || (SYL_ROUTER_EXTRA_ACTION == '3'))) {
            $action_method = $data->get(SYL_ACTION_KEY);
        }
        // ֤
        if ($action_method !== null) {
            $this->action_method = ucfirst($action_method);
        }

        // PATH_INFO
        $pathinfo = explode('/', $pathinfo);
        array_shift($pathinfo);
        if (count($pathinfo) > 0) {
            array_pop($pathinfo);
        }

        // 饹ե
        $classname = implode('_', array_map('ucfirst', $pathinfo));
        if ($classname) {
            $this->action_class = $classname . '_' . basename($this->action_file, $this->exe_ext);
        } else {
            $this->action_class = basename($this->action_file, $this->exe_ext);
        }

/*
echo "pathinfo: " . $pathinfo . "<br>";
echo "action_method: " . $this->action_method . "<br>";
echo "action_file: " . $this->action_file . "<br>";
echo "class_name: " . $this->action_class . "<br>";
exit;
*/
    }

}

?>
