<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter2_0.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 2.0饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter2_0.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssWriter2_0 extends SyL_XmlRssWriter
{
    /**
     * ͥǤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function setChannel($name, $value, $attributes=array())
    {
        // ݲ̾Ѵ
        switch ($name) {
        case 'date':
            $name = 'pubDate';
        case 'pubDate':
        case 'lastBuildDate':
            $value = $this->convertDateTime($value);
            break;
        case 'contributor':
        case 'author':
        case 'id':
            return;
        }
        parent::setChannel($name, $value, $attributes);
    }

    /**
     * ܤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function addItem($values, $attributes=array())
    {
        // ݲ̾Ѵ
        foreach (array_keys($values) as $name) {
            switch ($name) {
            case 'date':
                $values['pubDate'] = $this->convertDateTime($values[$name]);
                unset($values[$name]);
                break;
            case 'pubDate':
                $values[$name] = $this->convertDateTime($values[$name]);
                break;
            case 'id':
                $values['guid'] = $values[$name];
                unset($values[$name]);
                break;
            case 'copyright':
            case 'contributor':
                unset($values[$name]);
                break;
            }
        }
        parent::addItem($values, $attributes);
    }

    /**
     * RSS XML
     * 
     * @access public
     */
    function createXml()
    {
        $version = '';
        if (preg_match('/^SyL_XmlRssWriter(.+)$/i', get_class($this), $matches)) {
            $version = str_replace('_', '.', $matches[1]);
        }
        $this->addStartElement('rss', array('version' => $version));
        $this->addStartElement('channel');

        // ͥ
        foreach ($this->channel as $i => $values) {
            $this->createRecursiveElements($values[0], $values[1], (isset($this->channel_attr[$i]) ? $this->channel_attr[$i] : array()));
        }

        // 
        if (count($this->image) > 0) {
            $this->addStartElement('image');
            foreach ($this->image as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // ƥ
        if (count($this->textinput) > 0) {
            $this->addStartElement('textinput');
            foreach ($this->textinput as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // ƥ
        foreach ($this->items as $item) {
            $this->addStartElement('item');
            foreach ($item as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        $this->addEndElement();
        $this->addEndElement();
    }

    /**
     * եޥåȤѴ
     *
     * 2007/03/12 00:00:00 -> Mon, 12 Mar 2007 00:00:00 +0900
     *
     * @access public
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        if (preg_match('/^([0-9]{4})[\-|\/]?([0-1][0-9])[\-|\/]?([0-3][0-9])[ ]*([0-2][0-9]:?[0-5][0-9]:?[0-5][0-9])?$/', trim($datetime))) {
            $timestamp = @strtotime($datetime);
            if ($timestamp) {
                $datetime = date('D, d M Y H:i:s +0900', $timestamp);
            }
        }
        return $datetime;
    }
}

?>
