<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Template.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ƥץ졼ȥե饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Template.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Template
{
    var $c_template; // 󥸥

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Template()
    {
    }

    /**
     * ƥץ졼Ⱥ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $project_dir    = $data->get('d');
        $app_name       = $data->get('w');
        $template_files = $data->get('t');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        $app_dir = $project_dir . 'app/' . $app_name . '/';

        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ƥץ졼ȥեå
        // -------------------------------------------------
        $template_dir = $app_dir . 'templates/';
        $cnt = count($template_files);
        if ($cnt == 0) {
            trigger_error("[SyL error] Template file not found", E_USER_ERROR);
            exit;
        }

        foreach ($template_files as $template_file) {
            if (!preg_match('/^(\\\\|\/)/', $template_file)) {
                $template_file = '/' . $template_file;
            }
            if (substr($template_file, -5) != '.html') {
                $template_file .= '.html';
            }
            if (file_exists($template_dir . $template_file)) {
                trigger_error("[SyL error] Already template file exists ({$template_dir}{$template_file})", E_USER_ERROR);
                exit;
            }
        }

        // -------------------------------------------------
        // ƥץ졼ȥե
        // -------------------------------------------------
        $this->c_template->trigger($project_dir, $app_name, $template_files);
    }

}

?>
