<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateApplication.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץꥱǥ쥯ȥݡͥȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateApplication.php,v 1.1 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class CreateApplication
{
    /**
     * ץꥱǥ쥯ȥ
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     */
    function trigger($project_dir, $app_name)
    {
        $app_dir = "{$project_dir}app/{$app_name}/";
        if (!is_dir($app_dir)) {
            echo "  creating directory {$app_dir}\n"; ob_flush();
            if (!mkdir($app_dir, 0755)) {
                trigger_error("[SyL error] Application directory can't create ({$app_dir})", E_USER_ERROR);
                exit;
            }
        }

        $dirs = array(
          'actions'   => 0755,
          'templates' => 0755
        );

        $files = array(
          'actions.xml'     => 'actions.xml',
          'defines_app.xml' => 'defines.xml',
          'filters.xml'     => 'filters.xml',
          'layouts.xml'     => 'layouts.xml',
          'CommonPreAction.php'  => 'CommonPreAction.php',
          'CommonPostAction.php' => 'CommonPostAction.php'
        );

        foreach ($dirs as $dir => $mode) {
            if (!is_dir($app_dir . $dir)) {
                echo "  creating directory {$app_dir}{$dir}\n"; ob_flush();
                mkdir("{$app_dir}{$dir}");
                chmod("{$app_dir}{$dir}", $mode);
            }
        }

        foreach ($files as $file_org => $file_dist) {
            echo "  copying file {$app_dir}{$file_dist}\n"; ob_flush();
            if (file_exists("{$project_dir}var/skel-templates/{$file_org}")) {
                copy("{$project_dir}var/skel-templates/{$file_org}", "{$app_dir}{$file_dist}");
            } else {
                copy(SYL_PROJECT_DIR . '/var/skel-templates/{$file_org}', "{$app_dir}{$file_dist}");
            }
        }
    }
}

?>
