<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.6 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.6 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Auth
{
    /**
     * å󥪥֥
     * 
     * @access private
     * @var object
     */
    var $session = null;
    /**
     * å̾
     * 
     * @access private
     * @var string
     */
    var $session_name = 'syl_auth_session';
    /**
     * 桼IDѥ᡼̾
     * 
     * @access private
     * @var string
     */
    var $username = 'login_username';
    /**
     * ѥɥѥ᡼̾
     * 
     * @access private
     * @var string
     */
    var $password = 'login_passwd';
    /**
     * ѥǧڤŹ沽ϥå岽ƹԤ
     *
     * ξϡʿʸ
     * 
     * @access private
     * @var string
     */
    var $password_func = 'md5';
    /**
     * ͤ򥻥åȤ륻åѿ̾
     *
     * @access private
     * @var string
     */
    var $challenge_response_session_name = 'syl_auth_challenge';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Auth()
    {
        list($username, $password) = explode(':', SYL_AUTH_LOGIN_PARAMETER, 2);
        // ǧڥѥ᡼̾å
        $this->setUserParamaterName($username);
        $this->setPasswordParamaterName($password);
    }

    /**
     * SyL_Auth饹Υ󥹥󥹼
     *
     * @access public
     * @param string ǧڥ
     * @return object ǧڥ֥
     */
    function &singleton($type='')
    {
        static $singleton = array();
        if (!$type) {
            list($type) = explode(':', SYL_AUTH_TYPE, 2);
        }

        if (!isset($singleton[$type])) {
            SyL_Loggers::info("[Auth] Type {$type}");

            $classname = 'SyL_Auth' . ucfirst($type);
            include_once SYL_INCLUDE_DIR . "/framework/Auth/{$classname}.php";
            $request =& SyL_Request::singleton();
            $singleton[$type] = new $classname();
            $singleton[$type]->setSessionObject($request->getSessionObject());
        }
        return $singleton[$type];
    }

    /**
     * å󥪥֥Ȥ򥻥åȤ
     * 
     * @access private
     * @param object å󥿥
     */
    function setSessionObject(&$session)
    {
        $this->session =& $session;
    }

    /**
     * 桼IDѥ᡼̾򥻥å
     * 
     * @access public
     * @param string 桼IDѥ᡼̾
     */
    function setUserParamaterName($username)
    {
        $this->username = $username;
    }

    /**
     * ѥɥѥ᡼̾򥻥å
     * 
     * @access public
     * @param string ѥɥѥ᡼̾
     */
    function setPasswordParamaterName($password)
    {
        $this->password = $password;
    }

    /**
     * å̾򥻥å
     * 
     * @access public
     * @param string å̾
     */
    function setSessionName($session_name)
    {
        $this->session_name = $session_name;
    }

    /**
     * ѥɰŹ沽ؿ̾򥻥å
     * 
     * @access public
     * @param string ѥɰŹ沽ؿ̾
     */
    function setPasswordFunc($password_func)
    {
        $this->password_func = $password_func;
    }

    /**
     * ǧڥꥢȽ
     * 
     * @access public
     * @return bool true: ǧڥꥢfalse: ǧڥꥢ
     */
    function isAuthArea()
    {
        $session_error_url = call_user_func(array(__CLASS__, 'getAuthSessionErrorUrl'));
        if ($_SERVER['PHP_SELF'] == $session_error_url) {
            return false;
        }

        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '/';
        $auth_url    = call_user_func(array(__CLASS__, 'getAuthUrl'));
        return (bool)preg_match('/^' . preg_quote($auth_url, '/') . '/', $request_uri);
    }

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        return (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_POST[$this->username]) && isset($_POST[$this->password]));
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
        return false;
    }

    /**
     * ǧڥѥȽ
     * 
     * @access protected
     * @param string 饤桼̾
     * @param string 饤ѥ
     * @param string С¦ѥ
     * @param string С¦ϥå岽ˡ
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLoginPassword($client_username, $client_password, $server_password)
    {
        if (!$this->isLoginAction()) {
            SyL_Loggers::warn("[Auth] Login Failed. No Login Action. (class: " . get_class($this) . " user: {$client_username} hash: " . SYL_AUTH_PASSWORD_HASH . ")");
            return false;
        }
        if (($client_username === null) || ($client_username === '')) {
            SyL_Loggers::warn("[Auth] Login Failed. Empty UserName. (class: " . get_class($this) . " user: {$client_username} hash: " . SYL_AUTH_PASSWORD_HASH . ")");
            return false;
        }

        // ѥɥϥå岽
        $hashes = array_map('trim', explode(':', SYL_AUTH_PASSWORD_HASH));
        if ((count($hashes) == 2) && ($hashes[0] || $hashes[1])) {
            $challenge = $this->getChallengeCode();
            if ($hashes[0] && $hashes[1]) {
                //  饤ȡʥϥå -> Сʥϥå
                //    => Τޤ
                if ($challenge) {
                    // - 󥸤
                    //  CL: md5(  md5(ѥ))
                    //  SV: ѥ == md5(  ѥ)
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: {$hashes[1]} challenge: on");
                    $server_password = call_user_func($hashes[0], $challenge . $server_password);
                } else {
                    // - 󥸤ʤ
                    //  CL: md5(ѥ)
                    //  SV: ѥ == ѥ
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: {$hashes[1]} challenge: off");
                }
            } else if ($hashes[0]) {
                //  饤ȡʥϥå -> Сʿ
                //    => С¦ѥɤϥå岽
                if ($challenge) {
                    // - 󥸤
                    //  CL: md5(  md5(ѥ))
                    //  SV: ѥ == md5(  md5(ѥ))
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: (none) challenge: on");
                    $server_password = call_user_func($hashes[0], $server_password);
                    $server_password = call_user_func($hashes[0], $challenge . $server_password);
                } else {
                    // - 󥸤ʤ
                    //  CL: md5(ѥ)
                    //  SV: ѥ == md5(ѥ)
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: (none) challenge: off");
                    $server_password = call_user_func($hashes[0], $server_password);
                }
            } else if ($hashes[1]) {
                //  饤ȡʿ -> Сʥϥå
                //    => ѥɤϥå岽
                //  CL: ʤ
                //  SV: md5(ѥ)  == ѥ
                SyL_Loggers::info("[Auth] Auth hash CL: (none) SV: {$hashes[1]} challenge: off");
                $client_password = call_user_func($hashes[1], $client_password);
            } else {
                trigger_error("[SyL error] Unknown auth error", E_USER_ERROR);
            }
        } else {
            //  饤ȡʿ -> Сʿ
            //    => Τޤ
            //  CL: ʤ
            //  SV: ѥ == ѥ
            SyL_Loggers::info("[Auth] Auth hash CL: (none) SV: (none) challenge: off");
        }

        if ($server_password === $client_password) {
            $this->session->set($this->session_name, $client_username);
            SyL_Loggers::info("[Auth] Login Success. (class: " . get_class($this) . " user: {$client_username})");
            return true;
        } else {
            SyL_Loggers::warn("[Auth] Login Failed. Invalid Password. (class: " . get_class($this) . " user: {$client_username})");
            return false;
        }
    }

    /**
     * ǧڥå
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLogin()
    {
        return $this->session->is($this->session_name);
    }

    /**
     * ǧڥå
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function deleteLogin()
    {
        $this->session->delete($this->session_name);
    }

    /**
     * ȽԤ
     * 
     * @access public
     * @return boolean OK: true, NG: false
     */
    function doLogout()
    {
        $client_username = $this->session->get($this->session_name);
        SyL_Loggers::info("[Auth] Logout Success. (class: " . get_class($this) . " user: {$client_username})");
        $this->deleteLogin();
    }

    /**
     * 󥸥ɤå˥åȤơ
     * 
     * @access public
     * @param string 󥸥ɤη
     * @return string 󥸥
     */
    function createChallengeCode($len=8)
    {
        $challenge = '';
        for ($i=0; $i<$len; $i++) {
            $challenge .= chr(mt_rand(48, 126));
        }
        $challenge = str_replace('\\', '_', $challenge); // \ ֤
        $this->session->set($this->challenge_response_session_name, $challenge);
        return $challenge;
    }

    /**
     * 󥸥ɤ
     * 
     * @access public
     * @return string 󥸥
     */
    function getChallengeCode()
    {
        $challenge = $this->session->get($this->challenge_response_session_name);
        return $challenge;
    }

    /**
     * TOPURL
     * 
     * @static
     * @access public
     */
    function getAuthUrl()
    {
        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
        $script_name = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '';
        if ($request_uri && $script_name) {
            if (preg_match ('/^' . preg_quote($script_name, '/') . '/', $request_uri)) {
                return $script_name . SYL_AUTH_PATHINFO;
            } else {
                // ĥҤ̵б
                $path_parts = pathinfo($script_name);
                if (isset($path_parts['extension'])) {
                    $path_parts['basename'] = basename($script_name, '.' . $path_parts['extension']);
                }
                if ($path_parts['dirname'] == '/') {
                    $path_parts['dirname'] = '';
                }
                return $path_parts['dirname'] . '/' . $path_parts['basename'] . SYL_AUTH_PATHINFO;
            }
        } else {
            trigger_error("[SyL error] Unable to get env(_SERVER['REQUEST_URI'] or _SERVER['SCRIPT_NAME'])", E_USER_ERROR);
        }
    }

    /**
     * å󥨥顼̤إ쥯
     * 
     * @static
     * @access public
     * @param string ɲåꥹȥ
     */
    function redirectTop($query_string='')
    {
        if ($query_string) {
            $query_string = '?' . $query_string;
        }
        SyL_Response::redirect(call_user_func(array(__CLASS__, 'getAuthUrl')) . $query_string);
    }

    /**
     * å󥨥顼URL
     * 
     * @static
     * @access public
     */
    function getAuthSessionErrorUrl()
    {
        return SYL_AUTH_SESSION_ERROR_URL ? SYL_AUTH_SESSION_ERROR_URL : '/';
    }

    /**
     * å󥨥顼̤إ쥯
     * 
     * @static
     * @access public
     * @param string ɲåꥹȥ
     */
    function redirectSessionError($query_string='')
    {
        if ($query_string) {
            $query_string = '?' . $query_string;
        }
        SyL_Response::redirect(call_user_func(array(__CLASS__, 'getAuthSessionErrorUrl')) . $query_string);
    }

}

?>
