<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableConditions.php,v 1.4 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQL饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableConditions.php,v 1.4 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlTableConditions
{
    /**
     * ơ֥̾
     * 
     * @access private
     * @var string
     */
    var $alias = '';
    /**
     * 
     * 
     * @access private
     * @var array
     */
    var $wheres = array();

    /**
     * ơ֥̾򥻥åȤ
     *
     * @access public
     * @param string ơ֥̾
     */
    function setAlias($alias)
    {
        $this->alias = $alias;
    }

    /**
     * whereѥ᡼
     *
     * @access public
     * @return array whereѥ᡼
     */
    function gets()
    {
        return $this->wheres;
    }

    /**
     * SQLʸ
     *
     * @access public
     * @param object ͥ󥪥֥
     * @return string SQLʸ
     */
    function getWhere(&$conn)
    {
        $wheres = array();
        $first  = true;
        $or     = false;
        foreach ($this->wheres as $where) {
            if ($this->alias) {
                // ̾å
                $where[0] = "{$this->alias}.{$where[0]}";
            }
            switch ($where[2]) {
            case 'IS NULL':
            case 'IS NOT NULL':
                $wheres[] = "{$where[0]} {$where[2]} ";
                break;
            case 'IN':
            case 'NOT IN':
                $wheres[] = "{$where[0]} {$where[2]} (" . implode(',', array_map(array(&$conn, 'quote'), $where[1])) . ") ";
                break;
            case 'BETWEEN':
                $wheres[] = "{$where[0]} {$where[2]} " . $conn->quote($where[1][0]) . " AND " . $conn->quote($where[1][1]) . " ";
                break;
            default:
                $wheres[] = "{$where[0]} {$where[2]} " . $conn->quote($where[1]) . " ";
            }
            if ($first) {
                $first = false;
            } else {
                $max = count($wheres) - 1;
                if ($where[3] == 'OR') {
                    if (!$or) {
                        $wheres[$max-1] = '(' . $wheres[$max-1];
                        $or = true;
                    }
                } else {
                    if ($or) {
                        $wheres[$max-1] = $wheres[$max-1] . ')';
                        $or = false;
                    }
                }
                $wheres[$max] = ' ' . $where[3] . ' ' . $wheres[$max];
            }
        }

        if ($or) {
            return implode('', $wheres) . ') ';
        } else {
            return implode('', $wheres);
        }
    }

    /**
     * whereӡ
     *
     * @access public
     * @param string ̾
     * @param string 
     * @param bool true: =, false: <>
     * @param bool true: AND, false: OR
     */
    function addEqual($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? '=' : '<>';
        $this->add($name, $value, $op, $and);
    }

    /**
     * wheregreater thanӡ
     *
     * @access public
     * @param string ̾
     * @param string 
     * @param bool true: =, false: <>
     * @param bool true: AND, false: OR
     */
    function addGt($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? '>=' : '>';
        $this->add($name, $value, $op, $and);
    }

    /**
     * whereless thanӡ
     *
     * @access public
     * @param string ̾
     * @param string 
     * @param bool true: =, false: <>
     * @param bool true: AND, false: OR
     */
    function addLt($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? '<=' : '<';
        $this->add($name, $value, $op, $and);
    }

    /**
     * whereNULLӡ
     *
     * @access public
     * @param string ̾
     * @param string ͡ʥߡ͡
     * @param bool true: IS NULL, false: IS NOT NULL
     * @param bool true: AND, false: OR
     */
    function addNull($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? 'IS NULL' : 'IS NOT NULL';
        $this->add($name, null, $op, $and);
    }

    /**
     * whereLIKEӡ
     *
     * @param string ̾
     * @param string 
     * @param bool true: LIKE, false: NOT LIKE
     * @param bool true: AND, false: OR
     */
    function addLike($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? 'LIKE' : 'NOT LIKE';
        $this->add($name, $value, $op, $and);
    }

    /**
     * whereINӡ
     *
     * @param string ̾
     * @param array 
     * @param bool true: IN, false: NOT IN
     * @param bool true: AND, false: OR
     */
    function addIn($name, $value, $equal=true, $and=true)
    {
        $op = ($equal) ? 'IN' : 'NOT IN';
        if (!is_array($value)) {
            trigger_error("[SyL error] `" . __FUNCTION__ . "' method second parameter Array only", E_USER_ERROR);
        }
        $this->add($name, $value, $op, $and);
    }

    /**
     * whereBETWEENӡ
     *
     * @access public
     * @param string ̾
     * @param array 
     * @param bool ʥߡ͡
     * @param bool true: AND, false: OR
     */
    function addBetween($name, $value, $equal=true, $and=true)
    {
        if (!is_array($value)) {
            trigger_error("[SyL error] `" . __FUNCTION__ . "' method second parameter Array only", E_USER_ERROR);
        }
        $this->add($name, $value, 'BETWEEN', $and);
    }

    /**
     * where
     *
     * @access private
     * @param string ̾
     * @param mixed 
     * @param string 黻
     * @param bool true: AND, false: OR
     */
    function add($name, $value, $operator, $and)
    {
        $operator = strtoupper($operator);
        $logical  = $and ? 'AND' : 'OR';
        switch ($operator) {
        case '=':
        case '!=':
        case '<>':
        case '>':
        case '>=':
        case '<':
        case '<=':
        case 'NULL':
        case 'IS NULL':
        case 'NOT NULL':
        case 'IS NOT NULL':
        case 'LIKE':
        case 'NOT LIKE':
        case 'IN':
        case 'NOT IN':
        case 'BETWEEN':
            break;
        default:
            trigger_error("[SyL error] Not supported operator ({$operator})", E_USER_ERROR);
        }

        $this->wheres[] = array($name, $value, $operator, $logical);
    }
}

?>
