<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableRelations.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLϢ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlTableRelations.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlTableRelations
{
    /**
     * 
     * 
     * @access private
     * @var array
     */
    var $conditions = array();

    /**
     * ʸ
     *
     * @access public
     * @return string SQLʸ
     */
    function getJoin()
    {
        $from = '';
        $first = true;
        $aliases = array();
        foreach ($this->conditions as $condition) {
            if ($first) {
                $from .= $condition[0]['name'] . ' ';
                if ($condition[0]['name'] != $condition[0]['alias']) {
                    $from .= $condition[0]['alias'] . ' ';
                }
                $aliases[] = $condition[0]['alias'];
                $first = false;
            }

            list($column1, $column2)    = array_map('trim', explode('=', $condition[3][0]));
            list($alias1, $columnname1) = explode('.', $column1, 2);
            list($alias2, $columnname2) = explode('.', $column2, 2);

            // ˷礷ơ֥򸡺
            $a = $b = false;
            $join_alias = '';
            if (array_search($alias1, $aliases) !== false) {
                $join_alias = $alias2;
                $a = true;
            }
            if (array_search($alias2, $aliases) !== false) {
                $join_alias = $alias1;
                $b = true;
            }

            if ($a && $b) {
                // ˷ѤߤΥơ֥ϥå
                continue;
            } else if (!$a && !$b) {
                trigger_error("[SyL error] Alias name not found", E_USER_ERROR);
            }

            switch ($condition[2]) {
            case '=':  $from .= "INNER JOIN ";      break;
            case '+':  $from .= "LEFT OUTER JOIN "; break;
            default: trigger_error("[SyL error] Not supported operator ({$condition[2]})", E_USER_ERROR);
            }

            if ($join_alias == $condition[0]['alias']) {
                $from .= $condition[0]['name'] . ' ';
                if ($condition[0]['name'] != $condition[0]['alias']) {
                    $from .= $condition[0]['alias'] . ' ';
                }
                $aliases[] = $condition[0]['alias'];
            } else if ($join_alias == $condition[1]['alias']) {
                $from .= $condition[1]['name'] . ' ';
                if ($condition[1]['name'] != $condition[1]['alias']) {
                    $from .= $condition[1]['alias'] . ' ';
                }
                $aliases[] = $condition[1]['alias'];
            }
            $from .= "ON " . implode(' AND ', $condition[3]) . ' ';
        }

        return $from;
    }

    /**
     * 
     *
     * @access public
     * @param object ơ֥륪֥1
     * @param object ơ֥륪֥2
     * @param string 黻
     * @param array Ϣ
     */
    function addJoin($table1, $table2, $operator, $columns)
    {
        $column1 = array('name' => $table1->getName(), 'alias' => $table1->getAliasName());
        $column2 = array('name' => $table2->getName(), 'alias' => $table2->getAliasName());
        $this->add($column1, $column2, $operator, $columns);
    }

    /**
     * 
     *
     * @access private
     * @param array ̾1
     * @param array ̾2
     * @param string 黻
     */
    function add($column1, $column2, $operator, $columns)
    {
        switch ($operator) {
        case '=':
        case '+':
            break;
        default:
            trigger_error("[SyL error] Not supported operator ({$operator})", E_USER_ERROR);
        }
        $this->conditions[] = array($column1, $column2, $operator, $columns);
    }
}

?>
