<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.3 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - 
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.3 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperationLst extends SyL_AdmOperation
{
    /**
     * ɽǡ
     *
     * @access public
     * @param string ȹ
     * @param int ڡ
     * @return array ɽǡ
     */
    function getList($sort=null, $page=1, $limit='')
    {
        // ȹ
        $sorts = ($sort) ? explode(',', $sort) : $this->form->getStructConfig('default_sort');
        // 1ڡɽ
        if ($limit === '') {
            $limit = $this->form->getStructConfig('page_records');
        }

        $tables = array();
        // ơ֥륪֥Ⱥ롼
        foreach (array_keys($this->tables) as $alias) {
            $table =& $this->tables[$alias];
            // 
            $conditions = $this->dao->createCondition();
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (($value != null) && ($value !== '')) {
                    $conditions->addLike($column, '%' . $this->conn->escapeLike($value) . '%');
                }
            }
            $table->setConditions($conditions);
            // 
            foreach ($sorts as $sort) {
                list($alias_tmp) = explode('.', $sort, 2);
                if ($alias == $alias_tmp) {
                    $table->addSortLink($sort);
                }
            }
            $tables[$alias] =& $table;
        }

        // ڡ󥻥å
        $this->dao->setPage($page, $limit);
        // ɽǡ
        $results = $this->dao->select($tables, $this->relation);
        
        $options = array();
        foreach (array_keys($this->dao->getSelectHeaders()) as $name) {
            $options[$name] = $this->form->getOption($name);
        }

        $cnt = count($results);
        for ($i=0; $i<$cnt; $i++) {
            foreach ($results[$i] as $name => $value) {
                if ($options[$name] !== null) {
                    if (isset($options[$name][$value])) {
                        $results[$i][$name] = $options[$name][$value];
                    } else {
                        $results[$i][$name] = '';
                    }
                }
            }
        }
        return $results;
    }

    /**
     * Ȥθͤ
     *
     * @access public
     * @return array 
     */
    function getSearchParameters()
    {
        $search_parameters = array();
        // ơ֥륪֥Ⱥ롼
        foreach (array_keys($this->tables) as $alias) {
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (($value != null) && ($value !== '')) {
                    $search_parameters[] = $column . '=' . urlencode($value);
                }
            }
        }
        return $search_parameters;
    }

    /**
     * ڡ֥Ȥ
     *
     * @access public
     * @return object ڡ֥
     */
    function &getPager()
    {
        return $this->dao->getPager();
    }

    /**
     * ڡϰ
     *
     * @access public
     * @param object ڡ֥
     * @param int ڡɽ
     * @return array ڡϰ
     */
    function getPageLinks(&$pager, $range=9)
    {
        list($start, $end) = $pager->getRange($range);
        $links = array();
        for ($i=$start; $i<=$end; $i++) {
            $links[] = $i;
        }
        return $links;
    }

    /**
     * إåɽܤ
     *
     * @access public
     * @return array إåɽ
     */
    function getSelectHeaders()
    {
        $headers     = array();
        $headers_tmp = $this->dao->getSelectHeaders();
        // ¤ӽɽ̾ѹ
        foreach ($this->form->getListColumns() as $name) {
            $headers[$name] = $headers_tmp[$name];
            $headers[$name]['name'] = isset($this->form->elements_config[$name]['name']) ? $this->form->elements_config[$name]['name'] : $name;
        }
        return $headers;
    }

    /**
     * ȤΥȹܤ
     *
     * @access public
     * @return array ȤΥȹ
     */
    function getSortColumns()
    {
        return implode(',', $this->dao->getSortColumns());
    }

    /**
     * ǥեȸܥåɽȽ
     *
     * @access public
     * @return bool true: ɽfalse: ɽ
     */
    function isDefaultSearchView()
    {
        if ($this->isSch()) {
            return (bool)$this->form->getStructConfig('default_search_view');
        } else {
            return false;
        }
    }

    /**
     * ɽǡбץ饤ޥ꡼󥯤
     *
     * @access public
     * @param array ɽǡ
     * @return array ץ饤ޥ꡼
     */
    function getPrimaryLinkParameters(&$results)
    {
        $primary_link_parameters = array();
        $primaries = $this->getPrimary(true);
        foreach ($results as $i => $values) {
            $keys = array();
            foreach ($primaries as $name) {
                $column = substr($name, strpos($name, '.')+1);
                $keys[] = $name .'.' . $values[$column];
            }
            $primary_link_parameters[$i] = implode(',', $keys);
        }
        return $primary_link_parameters;
    }
}

?>
