<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.1 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 󥯥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.1 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Action
{
    /**
     * ᥽åɼ¹˼¹Ԥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function preExecute(&$data, &$context)
    {
    }

    /**
     * ᥽åɼ¹Ը˼¹Ԥ᥽å
     * 
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function postExecute(&$data, &$context)
    {
    }

    /**
     * DB֥Ȥ
     *
     * @access public
     * @param string DSNʸ
     * @return object DB֥
     */
    function &getDB($dsn='')
    {
        static $dsns = array();
        if (!isset($dsns[$dsn])) {
            include_once SYL_INCLUDE_DIR . '/lib/SyL_DB.php';
            $dsns[$dsn] =& SyL_DB::getConnection($dsn);
            $dsns[$dsn]->setCallbackSqlLog(array(__CLASS__, 'addLogDBSql'));
            $dsns[$dsn]->setCallbackErrorLog(array(__CLASS__, 'addLogDBError'));
            //register_shutdown_function(array(&$dsns[$dsn], 'closeConnection'));
            SyL_Loggers::info("[Action] DB start connection");
        }
        return $dsns[$dsn];
    }

    /**
     * DB֥Ȥ³
     *
     * @access public
     * @param object DB֥
     */
    function closeDB(&$conn)
    {
        if (is_object($conn)) {
            $conn->closeConnection();
            $conn = null;
            SyL_Loggers::info("[Action] DB end connection");
        }
    }

    /**
     * SQL˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBSql($message)
    {
        SyL_Loggers::debug("[DB] $message");
    }

    /**
     * DB顼˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBError($message)
    {
        SyL_Loggers::error("[DB] $message");
    }


    // validate
    // auth
    // form
}

?>
