<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.5 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ơ֥륹饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.5 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDaoTable
{
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $table = '';
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $alias = '';
    /**
     * ǥեե饰
     *
     * @access protected
     * @var array
     */
    var $is_defaul_all = true;
    /**
     * ץ饤ޥꥭ
     * 
     * @access protected
     * @var array
     */
    var $primary = array();
    /**
     * ե
     * 
     * @access protected
     * @var array
     */
    var $uniques = array();
    /**
     * 
     * 
     * @access protected
     * @var array
     */
    var $foreigns = array();
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $columns = array();
    /**
     * оݥ
     * 
     * @access private
     * @var array
     */
    var $data_columns = array();
    /**
     * оݥSQLؿ
     * 
     * @access private
     * @var array
     */
    var $data_functions = array();
    /**
     * 索֥
     * 
     * @access protected
     * @var object
     */
    var $conditions = null;
    /**
     * ȥ
     * 
     * @access protected
     * @var array
     */
    var $order_bys = array();
    /**
     * 롼ײ
     * 
     * @access protected
     * @var array
     */
    var $group_bys = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ơ֥̾
     */
    function SyL_DBDaoTable($table='', $columns=array())
    {
        if ($this->table == '') {
            $this->table = $table;
        }
        if (count($this->columns) == 0) {
            $this->columns = $columns;
        }
        // ̾ʸѴ
        $this->primary = array_map('strtoupper', $this->primary);
        $this->columns = array_change_key_case($this->columns, CASE_UPPER);
    }

    /**
     * ͤɲ
     *
     * @access public
     * @param string ̾
     * @param mixed 
     * @param array SQLؿ
     */
    function addColumn($name, $value=null, $function=null)
    {
        // ʸ
        $name = strtoupper($name);
        if (isset($this->columns[$name])) {
            if (is_array($function)) {
                $this->data_functions[$name] = $function;
            }
            $this->data_columns[$name] = $value;
        } else {
            trigger_error("[SyL error] Column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getName()
    {
        return $this->table;
    }

    /**
     * ơ֥̾򥻥å
     *
     * @access public
     * @param string ơ֥̾
     */
    function setAliasName($alias)
    {
        $this->alias = $alias;
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getAliasName()
    {
        return ($this->alias) ? $this->alias : $this->table;
    }

    /**
     * SELECTѥơ֥̾
     *
     * @access public
     * @return array SELECT
     */
    function getSelectName()
    {
        if ($this->alias) {
            return $this->getName() . ' ' . $this->alias;
        } else {
            return $this->getName();
        }
    }

    /**
     * ǥեե饰򥻥å
     *
     * @access public
     * @param bool ǥեե饰
     */
    function setDefaultAll($is_defaul_all)
    {
        $this->is_defaul_all = (bool)$is_defaul_all;
    }

    /**
     * 
     *
     * @access public
     * @return array 
     */
    function getColumns()
    {
        return $this->columns;
    }

    /**
     * 祭
     *
     * @access public
     * @param bool ̾ɲåե饰
     * @return array 祭
     */
    function getPrimary($alias_flag=true)
    {
        if ($alias_flag) {
            $alias = $this->getAliasName();
            $primary = array();
            foreach ($this->primary as $column) {
                $primary[] = "{$alias}.{$column}";
            }
            return $primary;
        } else {
            return $this->primary;
        }
    }

    /**
     * ե
     *
     * @access public
     * @param bool ̾ɲåե饰
     * @return array ե
     */
    function getUniques($alias_flag=true)
    {
        if ($alias_flag) {
            $alias = $this->getAliasName();
            $uniques = array();
            foreach ($this->uniques as $unique) {
                $tmp = array();
                foreach ($unique as $column) {
                    $tmp[] = "{$alias}.{$column}";
                }
                $uniques[] = $tmp;
            }
            return $uniques;
        } else {
            return $this->uniques;
        }
    }

    /**
     * 
     *
     * @access public
     * @param bool ̾ɲåե饰
     * @return array 
     */
    function getForeigns($alias_flag=true)
    {
        if ($alias_flag) {
            $alias = $this->getAliasName();
            $foreigns = array();
            foreach ($this->foreigns as $name => $foreign) {
                $tmp = array();
                foreach ($foreign as $column1 => $column2) {
                    $tmp["{$alias}.{$column1}"] = $column2;
                }
                $foreigns[$name] = $tmp;
            }
            return $foreigns;
        } else {
            return $this->foreigns;
        }
    }

    /**
     * 索֥Ȥ򥻥å
     *
     * @access public
     * @param object 索֥
     */
    function setConditions($conditions)
    {
        $this->conditions = $conditions;
    }

    /**
     * 索֥Ȥ
     *
     * @access public
     * @return object 索֥
     */
    function getConditions($alias_flag=true)
    {
        $conditions = $this->conditions;
        if ($alias_flag && ($conditions !== null)) {
            $conditions->setAlias($this->getAliasName());
        }
        return $conditions;
    }

    /**
     * ȥɲ
     *
     * @access public
     * @param string ȥ
     * @param bool Ƚ
     */
    function addSort($name, $asc=true)
    {
        // ʸ
        $name = strtoupper(trim($name));
        if (isset($this->columns[$name])) {
            $this->order_bys[] = array($name, $asc, false);
        } else if (array_search($name, $this->data_columns) !== false) {
            $this->order_bys[] = array($name, $asc, true);
        } else {
            trigger_error("[SyL error] Sort column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ȥ󥯤饽ȥɲ
     *
     * @access public
     * @param string ȥ
     */
    function addSortLink($linkname)
    {
        $sorts = array_map('trim', explode('.', $linkname, 3));
        if (count($sorts) == 3) {
            if ($this->getAliasName() == $sorts[0]) {
                $this->addSort($sorts[1], ($sorts[2] == 'ASC'));
            }
        }
    }

    /**
     * ȥ
     *
     * @access public
     * @param bool 祭ȥե饰
     * @return array ȥ
     */
    function getSorts($primary_sort=false)
    {
        $order_bys = $this->order_bys;
        if ($primary_sort) {
            foreach ($this->primary as $primary) {
                $exist = false;
                foreach ($order_bys as $order_by) {
                    if ($primary == $order_by[0]) {
                        $exist = true;
                        break;
                    }
                }
                if (!$exist) {
                    $order_bys[] = array($primary, true, false);
                }
            }
        }

        $result = array();
        for ($i=0; $i<count($order_bys); $i++) {
            $sort = ($order_bys[$i][1]) ? 'ASC' : 'DESC';
            if ($order_bys[$i][2]) {
                $result[$i] = $order_bys[$i][0] . ' ' . $sort;
            } else {
                $result[$i] = $this->getAliasName() . '.' . $order_bys[$i][0] . ' ' . $sort;
            }
        }
        return $result;
    }

    /**
     * 롼ײɲ
     *
     * @access public
     * @param string 롼ײ
     */
    function addGroup($name)
    {
        // ʸ
        $name = strtoupper(trim($name));
        if (isset($this->columns[$name])) {
            $this->group_bys[] = array($name, false);
        } else if (array_search($name, $this->data_columns) !== false) {
            $this->group_bys[] = array($name, true);
        } else {
            trigger_error("[SyL error] Group column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * 롼ײ
     *
     * @access public
     * @return array 롼ײ
     */
    function getGroups()
    {
        $result = array();
        for ($i=0; $i<count($this->group_bys); $i++) {
            if ($this->group_bys[$i][1]) {
                $result[$i] = $this->group_bys[$i][0];
            } else {
                $result[$i] = $this->getAliasName() . '.' . $this->group_bys[$i][0];
            }
        }
        return $result;
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectColumns(&$conn)
    {
        $columns_tmp = array();
        if (count($this->data_columns) > 0) {
            $columns_tmp = $this->data_columns;
        } else {
            if ($this->is_defaul_all) {
                foreach ($this->columns as $name => $value) {
                    $columns_tmp[$name] = null;
                }
            } else {
                return array();
            }
        }

        $columns = array();
        foreach ($columns_tmp as $name => $column_alias) {
            $column_tmp = '';
            if (isset($this->data_functions[$name])) {
                $funcs    = $this->data_functions[$name];
                $funcname = array_shift($funcs);
                $func = implode(',', array_map(array(&$conn, 'quote'), $funcs));
                if ($func != '') {
                    $func = ',' . $func;
                }
                $column_tmp = $funcname . '(' . $this->getAliasName() . '.' . $name . $func . ')';
            } else {
                $column_tmp = $this->getAliasName() . '.' . $name;
            }
            $columns[] = ($column_alias) ? "{$column_tmp} AS {$column_alias}" : $column_tmp;
        }
        return $columns;
    }

    /**
     * SELECT̾
     *
     * @access public
     * @return array SELECT̾
     */
    function getSelectHeaders()
    {
        $alias = $this->getAliasName() . '.';
        $tmp_columns    = array();
        $column_aliases = array();
        if (count($this->data_columns) > 0) {
            foreach (array_keys($this->data_columns) as $name) {
                if ($this->data_columns[$name]) {
                    $column_aliases[$name] = $this->data_columns[$name];
                }
                $tmp_columns[$name] = $this->columns[$name];
            }
        } else {
            if ($this->is_defaul_all) {
                $tmp_columns =& $this->columns;
            } else {
                return array();
            }
        }

        $columns = array();
        foreach (array_keys($tmp_columns) as $name) {
            if (isset($column_aliases[$name])) {
                $column_name = $name = $column_aliases[$name];
            } else {
                $column_name = $alias . $name;
            }
            $exist = false;
            foreach ($this->getSorts() as $order_by) {
                list($sort, $order) = explode(' ', $order_by, 2);
                if ($column_name == $sort) {
                    $columns[$name]['order'] = ($order == 'ASC') ? 'DESC' : 'ASC'; // 󥯤ʤΤǥȤ
                    $exist = true;
                    break;
                }
            }
            if (!$exist) {
                $columns[$name]['order'] = 'ASC';
            }
            $columns[$name]['sortlink'] = $alias . $name . '.' . $columns[$name]['order'];
        }
        return $columns;
    }

    /**
     * DMLѹܤ
     *
     * @access public
     * @param bool ơ֥̾ɲåե饰
     * @return array DMLѹ
     */
    function getDataColumns($is_alias=false)
    {
        $columns = array();
        foreach ($this->data_columns as $name => $value) {
            if (isset($this->data_functions[$name])) {
                $funcs    = $this->data_functions[$name];
                $funcname = array_shift($funcs);
                $func     = implode(',', array_map(array(&$conn, 'quote'), $funcs));
                $value    = "{$funcname}({$func})";
            }
            if ($is_alias && $this->alias) {
                $columns[$this->getAliasName() . '.' . $name] = $value;
            } else {
                $columns[$name] = $value;
            }
        }
        return $columns;
    }

    /**
     * ǡ
     *
     * @access public
     */
    function initDataColumns()
    {
        $this->data_columns = array();
    }
}

?>
