<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchemaPgsql.php,v 1.2 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB޼饹 (PostgreSQL)
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchemaPgsql.php,v 1.2 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSchemaPgsql extends SyL_DBSchema
{
    /**
     * ³ƤDBΥơ֥
     *
     * @access public
     * @return array ơ֥
     */
    function getTables()
    {
        $version = $this->conn->getVersion();
        $sql = "";
        if ($version && version_compare($version, '7.4', '>=')) {
            $sql .= "SELECT ";
            $sql .=   "c.relname, ";
            $sql .=   "(CASE ";
            $sql .=     "WHEN t.schemaname IS NOT NULL THEN t.schemaname ";
            $sql .=     "WHEN v.schemaname IS NOT NULL THEN v.schemaname ";
            $sql .=     "ELSE NULL ";
            $sql .=   "END) AS schemaname, ";
            $sql .=   "pg_get_userbyid(c.relowner) AS owner, ";
            $sql .=   "c.relkind ";
            $sql .= "FROM ";
            $sql .=   "pg_class c ";
            $sql .=     "LEFT OUTER JOIN pg_tables t ";
            $sql .=       "ON c.relname = t.tablename ";
            $sql .=     "LEFT OUTER JOIN pg_views v ";
            $sql .=       "ON c.relname = v.viewname ";
            $sql .= "WHERE ";
            $sql .=   "c.relkind IN ('r', 'v') AND ";
            $sql .=   "(v.viewname  IS NULL AND t.tablename IS NOT NULL AND t.schemaname <> 'information_schema' AND t.tablename NOT LIKE 'pg\\_%') OR ";
            $sql .=   "(t.tablename IS NULL AND v.viewname  IS NOT NULL AND v.schemaname <> 'information_schema' AND v.viewname  NOT LIKE 'pg\\_%') ";
        } else {
            $sql .= "SELECT ";
            $sql .=   "c.relname, ";
            $sql .=   "null AS schemaname, ";
            $sql .=   "pg_get_userbyid(c.relowner) AS owner, ";
            $sql .=   "c.relkind ";
            $sql .= "FROM ";
            $sql .=   "pg_class c ";
            $sql .= "WHERE ";
            $sql .=   "c.relkind IN ('r', 'v') AND ";
            $sql .=   "c.relname NOT LIKE 'pg\\_%' ";
        }

        $result = array();
        foreach ($this->conn->query($sql) as $table) {
            $result[] = array(
              'name'   => $table['RELNAME'],
              'schema' => $table['SCHEMANAME'],
              'owner'  => $table['OWNER'],
              'view'   => ($table['RELKIND'] == 'v')
            );
        }
        return $result;
    }

    /**
     * ꤷơ֥μ祭
     *
     * @access public
     * @param string ơ֥̾
     * @return array 祭
     */
    function getPrimary($tablename)
    {
        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "a.attname ";
        $sql .= "FROM  ";
        $sql .=   "pg_class c, ";
        $sql .=   "pg_attribute a ";
        $sql .= "WHERE ";
        $sql .=   "c.oid = a.attrelid AND ";
        $sql .=   "exists(SELECT * FROM pg_constraint ct WHERE c.oid = ct.conrelid and a.attnum = ANY(ct.conkey) and ct.contype = 'p') AND ";
        $sql .=   "c.relname = '" . $this->conn->escape($tablename) . "' ";
        $sql .= "ORDER BY ";
        $sql .=   "a.attnum ";

        $result = array();
        foreach ($this->conn->query($sql) as $column) {
            $result[] = $column['ATTNAME'];
        }
        return $result;
    }

    /**
     * ꤷơ֥ΰե
     *
     * @access public
     * @param string ơ֥̾
     * @return array ե
     */
    function getUniques($tablename)
    {
        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "ct.conname, ";
        $sql .=   "a.attname ";
        $sql .= "FROM ";
        $sql .=   "pg_class c, ";
        $sql .=   "pg_constraint ct, ";
        $sql .=   "pg_attribute a ";
        $sql .= "WHERE ";
        $sql .=   "c.oid = ct.conrelid AND ";
        $sql .=   "c.oid = a.attrelid AND ";
        $sql .=   "a.attnum = any(ct.conkey) AND ";
        $sql .=   "c.relname = '" . $this->conn->escape($tablename) . "' AND ";
        $sql .=   "ct.contype = 'u' AND ";
        $sql .=   "a.attnum > 0 ";

        $i = 0;
        $keys   = array();
        $result = array();
        foreach ($this->conn->query($sql) as $column) {
            $num = '';
            if (isset($keys[$column['CONNAME']])) {
                $num = $keys[$column['CONNAME']];
            } else {
                $keys[$column['CONNAME']] = $i;
                $result[$i] = array();
                $num = $i++;
            }
            $result[$num][] = $column['ATTNAME'];
        }
        return $result;
    }

    /**
     * ꤷơ֥γ
     *
     * @access public
     * @param string ơ֥̾
     * @return array 
     */
    function getForeigns($tablename)
    {
        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "a1.attname as attname1, ";
        $sql .=   "c2.relname, ";
        $sql .=   "a2.attname as attname2 ";
        $sql .= "FROM ";
        $sql .=   "pg_class c1, ";
        $sql .=   "pg_class c2, ";
        $sql .=   "pg_constraint ct, ";
        $sql .=   "pg_attribute a1, ";
        $sql .=   "pg_attribute a2 ";
        $sql .= "WHERE ";
        $sql .=   "c1.oid = ct.conrelid AND ";
        $sql .=   "c2.oid = ct.confrelid AND ";
        $sql .=   "c1.oid = a1.attrelid AND ";
        $sql .=   "c2.oid = a2.attrelid AND ";
        $sql .=   "a1.attnum = any(ct.conkey) AND ";
        $sql .=   "a2.attnum = any(ct.confkey) AND ";
        $sql .=   "c1.relname = '" . $this->conn->escape($tablename) . "' AND ";
        $sql .=   "ct.contype = 'f' AND ";
        $sql .=   "a1.attnum > 0 AND  ";
        $sql .=   "a2.attnum > 0 ";

        $result = array();
        foreach ($this->conn->query($sql) as $column) {
            if (!isset($result[$column['RELNAME']])) {
                $result[$column['RELNAME']] = array();
            }
            $result[$column['RELNAME']][$column['ATTNAME1']] = $column['ATTNAME2'];
        }
        return $result;
    }

    /**
     * ꤷơ֥Υ
     *
     * @access public
     * @param string ơ֥̾
     * @return array 
     */
    function getColumns($tablename)
    {
        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "a.attname, ";
        $sql .=   "case exists(SELECT * FROM pg_constraint ct WHERE c.oid = ct.conrelid and a.attnum = ANY(ct.conkey) and ct.contype = 'p') ";
        $sql .=     "when true then '1' ";
        $sql .=     "else '0' ";
        $sql .=   "end as pkey, ";
        $sql .=   "t.typname, ";
        $sql .=   "case t.typname ";
        $sql .=     "when 'bpchar' then atttypmod - 4 ";
        $sql .=     "when 'varchar' then atttypmod - 4 ";
        $sql .=     "when 'numeric' then (atttypmod - 4) / 65536 ";
        $sql .=     "else a.attlen ";
        $sql .=   "end as atttypmod, ";
        $sql .=   "case typname ";
        $sql .=     "when 'numeric' then (atttypmod - 4) % 65536 ";
        $sql .=     "when 'decimal' then (atttypmod - 4) % 65536 ";
        $sql .=     "else 0 ";
        $sql .=   "end as atttypmod1, ";
        $sql .=   "case a.attnotnull ";
        $sql .=     "when true then '1' ";
        $sql .=     "else '0' ";
        $sql .=   "end as attnotnull, ";
        $sql .=   "case a.atthasdef ";
        $sql .=     "when true then '1' ";
        $sql .=     "else '0' ";
        $sql .=   "end as atthasdef ";
        $sql .= "FROM  ";
        $sql .=   "pg_class c, ";
        $sql .=   "pg_attribute a, ";
        $sql .=   "pg_type t ";
        $sql .= "WHERE ";
        $sql .=   "c.oid = a.attrelid AND ";
        $sql .=   "a.atttypid = t.oid AND ";
        $sql .=   "c.relname = '" . $this->conn->escape($tablename) . "' AND  ";
        $sql .=   "a.attnum > 0  ";
        $sql .= "ORDER BY  ";
        $sql .=   "a.attnum ";

        $result = array();
        foreach ($this->conn->query($sql) as $column) {
            list($type, $min, $max) = $this->getFormat($column['TYPNAME'], $column['ATTTYPMOD'], $column['ATTTYPMOD1']);
            $result[$column['ATTNAME']] = array(
              'type'     => $type,
              'min'      => $min,
              'max'      => $max,
              'primary'  => ($column['PKEY'] == '1'),
              'not_null' => (($column['PKEY'] == '1') || ($column['ATTNOTNULL'] == '1')),
              'default'  => ($column['ATTHASDEF'] == '1')
            );
        }
        return $result;
    }

    /**
     * ෿Ф복׷
     *
     * @access private
     * @param string ෿
     * @param string Ĺ
     * @param string Ĺʾ
     * @return array ׷
     */
    function getFormat($type, $len1, $len2)
    {
        switch ($type) {
        case 'int2':
            return array('I', '-32768', '32767');
        case 'int4':
            return array('I', '-2147483648', '2147483647');
        case 'int8':
            return array('I', '-9223372036854775808', '9223372036854775807');
        case 'float4':
        case 'float8':
            return array('F', null, null);
        case 'numeric':
            $i = str_repeat('9', $len1 - $len2);
            $f = str_repeat('9', $len2);
            return array('N', "-{$i}.{$f}", "{$i}.{$f}");

        case 'varchar':
            if ($len1 > 0) {
                return array('S', '0', "{$len1}");
            } else {
                return array('S', null, null);
            }
        case 'bpchar':
            return array('S', '0', "{$len1}");
        case 'text':
            return array('S', null, null);

        case 'timestamp':
        case 'timestamptz':
        case 'date':
            return array('D', null, null);
        case 'time':
        case 'timetz':
            return array('T', null, null);
        default:
            return array('S', null, null);
        }
    }

}

?>
