<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendmail.php,v 1.11 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  Sendmail᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendmail.php,v 1.11 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSendmail extends SyL_Mail
{
    /**
     * Sendmailѥ
     *
     * @access private
     * @var string
     */
    var $sendmail_path = '/usr/lib/sendmail';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ѥ᡼
     */
    function SyL_MailSendmail($type)
    {
        if ($type) {
            $this->setSendmailPath($type);
        }
        parent::SyL_Mail();
    }

    /**
     * Sendmailޥɥѥ򥻥å
     * 
     * @access public
     * @param string Sendmailޥɥѥ
     */
    function setSendmailPath($sendmail_path)
    {
        $this->sendmail_path = $sendmail_path;
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     */
    function init($attributes=array())
    {
        parent::init($attributes);
        // Sendmailѥ
        if (isset($attributes['sendmail'])) {
            $this->sendmail_path = $attributes['sendmail'];
        }
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: null, NG: SyL_Error_Parameter֥
     */
    function send()
    {
        // Fromɬ
        if ($this->mail_property['MAIL_FROM'] == '') {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        // Toɬ
        if (count($this->mail_property['RCPT_TO']) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }
        // ꥿ѥΥå
        $additional_parameters = ' -f ' . $this->mail_property['MAIL_FROM'];

        // ᡼¹
        $pmail = popen($this->sendmail_path . ' -t -i' . $additional_parameters, 'w');
        if (!$pmail) {
            $this->error_message = "[SyL error] Sendmail command execute error ({$this->sendmail_path})";
            return false;
        }
        fputs($pmail, $this->createSendMessage());
        pclose($pmail);

        // 
        $this->init();

        return true;
    }
}

?>
