<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperation.php,v 1.6 2007/10/15 13:56:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DAO饹
 */
require_once SYL_INCLUDE_DIR . '/lib/DB/SyL_DBDao.php';
/**
 * DAOơ֥륯饹
 */
require_once SYL_INCLUDE_DIR . '/lib/DB/Dao/SyL_DBDaoTable.php';

/**
 * ̥쥤䡼ǡ饹 - 
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperation.php,v 1.6 2007/10/15 13:56:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperation
{
    /**
     * ե४֥
     *
     * @access private
     * @var object
     */
    var $form = null;
    /**
     * DB֥
     *
     * @access private
     * @var object
     */
    var $conn = null;
    /**
     * DAO֥
     *
     * @access private
     * @var object
     */
    var $dao = null;
    /**
     * ơ֥륪֥Ȥ
     *
     * @access private
     * @var array
     */
    var $tables = array();
    /**
     * ơ֥Ϣ֥Ȥ
     *
     * @access private
     * @var array
     */
    var $relation = null;
    /**
     * 祭
     * 
     * @access protected
     * @var array
     */
    var $keys = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ե४֥
     * @param object DB֥
     * @param array 祭
     */
    function SyL_AdmOperation(&$form, &$conn, $keys=array())
    {
        $this->form     =& $form;
        $this->conn     =& $conn;
        $this->dao      =& new SyL_DBDao($conn);
        $this->relation = $this->dao->createRelation();
        foreach ($keys as $key) {
           $key = $this->decodeKey($key);
           if (!is_array($key)) {
               trigger_error("[SyL error] Invalid primary parameter", E_USER_ERROR);
           }
           $this->keys[] = $key;
        }
    }

    /**
     * 饹Υץѥƥơ֥ȴϢ
     *
     * @access public
     */
    function loadConfig()
    {
        foreach ($this->form->getTableClasses() as $alias => $classname) {
            $classname = SyL_Loader::convertClass($classname, true);
            $table =& new $classname();
            $this->addTable($table, $alias);
        }
        $relations = $this->form->getTableRelations();
        if ($relations) {
            foreach ($relations as $columns) {
                $this->addRelation($columns);
            }
        }
    }

    /**
     * ơ֥륪֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object ơ֥륪֥
     * @param string ̾
     */
    function addTable(&$table, $alias)
    {
        // ɽ
        foreach ($this->form->getListColumns($alias) as $column) {
            // ơ֥륪֥Ȥ˼ɲ
            $table->addColumn($column);
            // ơ֥Хǡɲ
            $column_def = $table->getColumn($column);
            if (isset($column_def['validate'])) {
                $element_config = $this->form->getConfig($column);
                if (isset($element_config['validate'])) {
                    $element_config['validate'] = array_merge($column_def['validate'], $element_config['validate']);
                } else {
                    $element_config['validate'] = array();
                }
                $this->form->addConfig($column, $element_config);
            }
        }
        if ($alias && is_string($alias)) {
            // ǥեե饰̵
            $table->setDefaultAll(false);
            // ơ֥̾å
            $table->setAliasName($alias);
            $this->tables[$alias] =& $table;
        } else {
            trigger_error("[SyL error] Invalid table alias name ({$alias})", E_USER_ERROR);
        }
    }

    /**
     * Ϣ򥻥åȤ
     *
     * @access public
     * @param string Ϣ
     */
    function addRelation($join_column)
    {
        $columns  = explode(',', $join_column);
        $operator = array_shift($columns);
        list($column1, $column2) = array_map('trim', explode('=', $columns[0]));
        list($alias1, $columnname1) = explode('.', $column1, 2);
        list($alias2, $columnname2) = explode('.', $column2, 2);
        if ($operator == '+') {
            $this->relation->addLeftJoin($this->tables[$alias1], $this->tables[$alias2], $columns);
        } else {
            $this->relation->addInnerJoin($this->tables[$alias1], $this->tables[$alias2], $columns);
        }
    }

    /**
     * 祭
     *
     * @access public
     * @return array 祭
     */
    function getPrimary($alias_flag=true)
    {
        $name = $this->form->getMaintenanceTable();
        foreach (array_keys($this->tables) as $alias) {
            if ($name == $alias) {
                return $this->tables[$alias]->getPrimary($alias_flag);
            }
        }
        return array();
    }

    /**
     * ɽǽȽꤹ
     *
     * @access public
     * @return bool true: ɽǽfalse: ɽԲ
     */
    function isLst()
    {
        $enable = $this->form->getStructConfig('enable_lst');
        return ($enable === null) ? true : (bool)$enable;
    }

    /**
     * ϿǽȽꤹ
     *
     * @access public
     * @return bool true: Ͽǽfalse: ϿԲ
     */
    function isNew()
    {
        $enable = $this->form->getStructConfig('enable_new');
        return ($enable === null) ? true : (bool)$enable;
    }

    /**
     * ǽȽꤹ
     *
     * @access public
     * @return bool true: ǽfalse: Բ
     */
    function isUpd()
    {
        $enable = $this->form->getStructConfig('enable_upd');
        return ($enable === null) ? true : (bool)$enable;
    }

    /**
     * ǽȽꤹ
     *
     * @access public
     * @return bool true: ǽfalse: Բ
     */
    function isDel()
    {
        $enable = $this->form->getStructConfig('enable_del');
        return ($enable === null) ? true : (bool)$enable;
    }
     
    /**
     * ܺɽǽȽꤹ
     *
     * @access public
     * @return bool true: ܺɽǽfalse: ܺɽԲ
     */
    function isVew()
    {
        $enable = $this->form->getStructConfig('enable_vew');
        return ($enable === null) ? true : (bool)$enable;
    }

    /**
     * ܥåɽǽȽꤹ
     *
     * @access public
     * @return bool true: ɽǽfalse: ɽԲ
     */
    function isSch()
    {
        $enable = $this->form->getStructConfig('enable_sch');
        return ($enable === null) ? true : (bool)$enable;
    }

    /**
     * 祭ѥ᡼򥨥󥳡ɤ
     *
     * @access protected
     * @param array 祭ѥ᡼
     * @return string 󥳡ɸ祭ѥ᡼
     */
    function encodeKey($key)
    {
        $tmp = array();
        foreach ($key as $name => $value) {
            $tmp[] = "{$name}={$value}";
        }
        return implode("\t", $tmp);
    }

    /**
     * 祭ѥ᡼ǥɤ
     *
     * @access protected
     * @param string 祭ѥ᡼
     * @return array ǥɸ祭ѥ᡼
     */
    function decodeKey($key)
    {
        $tmp = array();
        foreach (explode("\t", $key) as $tmp1) {
            $tmp2 = explode('=', $tmp1);
            if (count($tmp2) != 2) {
                return array();
            }
            $tmp[$tmp2[0]] = $tmp2[1];
        }
        return $tmp;
    }

    /**
     * 祭ɲä
     *
     * @access protected
     * @param object 索֥
     * @param string ơ֥̾
     * @return bool true: 顼ʤfalse: 顼
     */
    function setConditionKey(&$conditions, $alias)
    {
        if (count($this->keys) == 0) {
            return false;
        }
        $valid = true;
        $and   = false;
        $primaries = $this->getPrimary(true);
        foreach ($this->keys[0] as $name => $value) {
            if (array_search("{$alias}.{$name}", $primaries) === false) {
                $valid = false;
                break;
            }
            $conditions->addEqual($name, $value, true, $and);
            $and = true;
        }
        return $valid;
    }

    /**
     * ܺɽǡ
     *
     * @access public
     * @return array ܺɽǡ
     */
    function getRecord()
    {
        $tables = array();
        $primaries = $this->getPrimary(true);
        foreach (array_keys($this->tables) as $alias) {
            // ơ֥륪֥ȼ
            $table =& $this->tables[$alias];
            if ($alias == $this->form->getMaintenanceTable()) {
                // 索֥Ⱥ
                $conditions = $this->dao->createCondition();
                // 祭糧å
                $this->setConditionKey($conditions, $alias);
                // 索֥ȥå
                $table->setConditions($conditions);
            }
            // ơ֥륪֥ȥå
            $tables[$alias] =& $table;
        }

        // ɽǡ
        $result = $this->dao->select($tables, $this->relation);
        return (count($result) == 0) ? null : $result[0];
    }

    /**
     * 祭ѥ᡼ƬΤߡ
     *
     * @access public
     * @return array 祭ѥ᡼
     */
    function getKey()
    {
        return (count($this->keys) > 0) ? $this->keys[0] : '';
    }

    /**
     * 祭ѥ᡼ƬΤߡ
     *
     * @access public
     * @return string 祭ѥ᡼
     */
    function getKeyQuery()
    {
        return (count($this->keys) > 0) ? $this->encodeKey($this->keys[0]) : '';
    }

    /**
     * Хǡ¹
     *
     * @access public
     * @return bool Хǡ
     */
    function validate()
    {
        return $this->form->validate();
    }
}

?>
