<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.24 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Action.php';

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.24 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigActions extends SyL_Config
{
    /**
     * ٥̾
     * 
     * @access protected
     * @var string
     */
    var $event = 'executeStream';
    /**
     * ǥեȼ¹Խ
     * 
     * @access protected
     * @param int
     */
    var $default_priority = 5;
    /**
     * ƥʥ̾
     * 
     * @access private
     * @var object
     */
    var $action_key = SYL_ACTION_KEY;
    /**
     * ǥեȥƥץ졼ȥ
     * 
     * @access private
     * @param string
     */
    var $default_template_type = 'default';
    /**
     * ե륭å奭
     * 
     * @access private
     * @param string
     */
    var $action_cache_key = '__syL_action_cache';
    /**
     * ե륭åǡ
     * 
     * @access private
     * @var array
     */
    var $action_cache_value = array();

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        // ١饹
        SyL_Loader::lib(SYL_ACTION_BASE_CLASS);

        if (SYL_CACHE) {
            // åѤ
            $key = SYL_APP_DIR . $this->context->getActionFile() . $this->context->getActionName();
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                // åѥ᡼¸
                $this->config[$this->action_cache_key] = $this->action_cache_value;
                $cache->write($this->config);
            } else {
                // åѥ᡼
                $this->action_cache_value = $this->config[$this->action_cache_key];
            }
            // åѥ᡼
            unset($this->config[$this->action_cache_key]);
        } else {
            // åѤʤ
            parent::parseXml();
        }

        if (!isset($this->config[$this->action_key])) {
            // б륢ޥåԥ󥰤¸ߤʤ
            trigger_error("[SyL error] Action mapping not found (" . $this->context->getActionFile() . ")", E_USER_ERROR);
        }

        // ӥ塼פ򥻥å
        $this->context->setViewType($this->action_cache_value['viewType']);
        // 쥤̾򥻥å
        $this->context->setLayoutName($this->action_cache_value['layoutName']);
        // ǥեȥƥץ졼Ȥ򥻥å
        if (isset($this->action_cache_value['template']) && $this->action_cache_value['template']) {
            $this->context->setTemplateFile($this->action_cache_value['template']);
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name             = '';
        static $pre_name         = '';
        static $post_name        = '';

        static $method_name      = '';
        static $pre_method_name  = '';
        static $post_method_name = '';

        static $component_name   = '';
        static $load             = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-actions/action':
            if ($name != '') {
                $name = '';
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // URLǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->context->getActionFile(), $matches)) {
                $name = $this->action_key;
                // ݡͥȥѥ᡼
                $this->config[$name] = array(
                    'class'       => $this->context->getClassName(),
                    'type'        => 'action',
                    'file'        => $this->context->getActionDir() . $this->context->getActionFile(),
                    'reference'   => true,
                    'priority'    => $this->default_priority, // ¹Խ
                    'constructor' => false, // 󥹥ȥ饯󥸥ե饰
                    'force'       => (SYL_ENV_TYPE == 'cmd'), // ե뤬¸ߤʤȥ顼Υե饰 ޥɥ饤Τߥե¸ߥå
                    'args'        => array() // 
                );

                // ̥
                $pre_name = 'pre_' . $name;
                $this->config[$pre_name] = $this->config[$name];
                $this->config[$pre_name]['priority']--; // ¹Խ(1ʳᤤ)
                $this->config[$pre_name]['event'][$this->event][] = $pre_name;

                // ̥
                $post_name = 'post_' . $name;
                $this->config[$post_name] = $this->config[$name];
                $this->config[$post_name]['priority']++; // ¹Խ(1ʳ٤)
                $this->config[$post_name]['event'][$this->event][] = $post_name;

                // ե뤬̵硢pre, postΤ߼¹
                if (!is_file($this->context->getActionDir() . $this->context->getActionFile())) {
                    $action_path  = '';
                    $action_class = '';
                    if (SYL_ACTION_BASE_CLASS) {
                        $action_path  = SyL_Loader::convertPath(SYL_ACTION_BASE_CLASS);
                        $action_class = SyL_Loader::convertClass(SYL_ACTION_BASE_CLASS);
                    }
                    if (is_file(SYL_APP_LIB_DIR . $action_path)) {
                        $action_path  = SYL_APP_LIB_DIR . $action_path;
                    } else if (is_file(SYL_PROJECT_LIB_DIR . $action_path)) {
                        $action_path = SYL_PROJECT_LIB_DIR . $action_path;
                    } else {
                        $action_path = SYL_INCLUDE_DIR . '/framework/SyL_Action.php';
                    }
                    $this->config[$pre_name]['file']   = $action_path;
                    $this->config[$pre_name]['class']  = $action_class;
                    $this->config[$post_name]['file']  = $action_path;
                    $this->config[$post_name]['class'] = $action_class;
                }

                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;

                // ݡͥȥѥ᡼ʳ
                $this->action_cache_value = array(
                    'viewType'   => isset($attribute['viewType'])   ? $attribute['viewType']   : '', // ӥ塼
                    'layoutName' => isset($attribute['layoutName']) ? $attribute['layoutName'] : ''  // 쥤
                );

                // ǥեȥƥץ졼ȼ
                if ((SYL_ENV_TYPE == 'web') && isset($attribute['template'])) {
                    $template = $attribute['template'];
                    for ($i=0; $i<count($matches); $i++) {
                        $template = str_replace("\${$i}", $matches[$i], $template);
                    }
                    $this->action_cache_value['template'] = $template;
                }
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-actions/action/setter':
                // 쥯ȥåȥ
                if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                    $method_name = 'setter:' . $attribute['name'] . ':true';
                } else {
                    $method_name = 'setter:set' . ucfirst($attribute['name']) . ':false';
                }
                $prepost_method_name = '';
                $this->config[$name]['event'][$this->event][] = $method_name;
                $this->config[$name]['args'][$method_name]    = array();
                break;

            case '/syl-actions/action/method':
                $method_name = 'method:' . str_replace('{$action}', $this->context->getActionName(), $attribute['name']);
                $this->config[$name]['args'][$method_name] = array();
                $this->config[$name]['event'][$this->event][] = $method_name; // ٥ȥ

                $pre_method_name = 'method:preExecute';
                $this->config[$pre_name]['args'][$pre_method_name] = array();
                $this->config[$pre_name]['event'][$this->event][]  = $pre_method_name; // ٥ȥ

                $post_method_name = 'method:postExecute';
                $this->config[$post_name]['args'][$post_method_name] = array();
                $this->config[$post_name]['event'][$this->event][]   = $post_method_name; // ٥ȥ
                break;

            case '/syl-actions/action/setter/arg':
            case '/syl-actions/action/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $arg  = "{$type}:{$ref}:{$text}";
                $this->config[$name]['args'][$method_name][]           = $arg;
                $this->config[$pre_name]['args'][$pre_method_name][]   = $arg;
                $this->config[$post_name]['args'][$post_method_name][] = $arg;
                break;

           case '/syl-actions/action/components/component':
                if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                    $component_name = '';
                    return;
                }
                $component_name = $attribute['name'];
                $this->config[$component_name]['type']      = 'component';
                $this->config[$component_name]['class']     = isset($attribute['class'])  ? $attribute['class'] : $component_name;
                $this->config[$component_name]['file']      = $attribute['file'];
                $this->config[$component_name]['reference'] = (isset($attribute['reference']) && ($attribute['reference'] === 'true'));
                // ¹Խ(2ʳᤤ)
                $default_priority = $this->default_priority - 2;
                $component_priority = isset($attribute['priority']) ? floatval($default_priority . '.' . $attribute['priority']) : $default_priority;
                $this->config[$component_name]['priority'] = $component_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$component_name]['constructor'] = false;
                // ե뤬¸ߤʤȥ顼Υե饰
                $this->config[$component_name]['force'] = false;
                // ٥ȥ
                $this->config[$component_name]['event'][$this->event][] = $component_name;
                // 
                $this->config[$component_name]['args'] = array();
                break;

            default:
                if (!$component_name) return;

                switch ($current_path) {
                case '/syl-actions/action/components/component/constructor':
                    $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                    // 󥹥ȥ饯󥸥ե饰
                    $this->config[$component_name]['constructor'] = true;
                    // 󥹥ȥ饯󥸥ξ硢Υ᥽åɤϺ
                    $index = array_search($component_name, $this->config[$component_name]['event'][$this->event]);
                    if ($index !== false) {
                        unset($this->config[$component_name]['event'][$this->event][$index]);
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter':
                    // 쥯ȥåȥ
                    if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                        $method_name = 'setter:' . $attribute['name'] . ':true';
                    } else {
                        $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/method':
                    $method_name = 'method:' . $attribute['name'];
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter/arg':
                case '/syl-actions/action/components/component/constructor/arg':
                case '/syl-actions/action/components/component/method/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;
                }
            }
        }
    }
}

?>
