<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.17 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹ߡ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.17 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigDefines extends SyL_Config
{
    /**
     * ƥȤ򥻥å
     * ƥȤʤΤ
     *
     * @access protected
     * @param object ȥ饪֥
     */
    function setContext(&$controller)
    {
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_CACHE) {
            // åѤ
            $key = SYL_APP_DIR;
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }

        // 
        $this->readConstants();
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        if ($current_path == '/syl-defines/define') {
            $this->config[$attribute['name']] = $text;
        }
    }

    /**
     * ɤ߹
     *
     * @access private
     */
    function readConstants()
    {
        foreach ($this->config as $key => $value) {
            $value = preg_replace_callback('/\{(\w+)\}/', array(&$this, 'replaceConstant'), $value);
            define($key, $value);
        }
    }

    /**
     * ֤Хå᥽å
     *
     * @access private
     * @param array ޥå
     @ return mixed ޥå
     */
    function replaceConstant($matches)
    {
        return defined($matches[1]) ? constant($matches[1]) : '{' . $matches[1] . '}';
    }
}

?>
