<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.23 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEB̥顼ɽ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.23 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorWeb extends SyL_Error
{
    /**
     * ɽԿ
     * ˤ
     *
     * @access private
     * @var int
     */
    var $display_source_line = 9;

    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $_error_trace)
    {
        // display_errorsoffξϥ顼̤ɽʤ
        if (!ini_get('display_errors')) {
            return;
        }

        // 顼å
        $_error_message = implode('<br>', $error_messages);

        // 顼
        $_error_lines = array();

        foreach ($_error_trace as $error) {
            $error_line = $error['line'];
            $error_file = $error['file'];
            if (is_numeric($error_line) && file_exists($error_file)) {
                $error_half_line = floor($this->display_source_line / 2);
                $start_line = 1;
                $crit_line  = 1;
                if (($error_line - $error_half_line) > 1) {
                    $start_line = $error_line - $error_half_line;
                }
                $i = 1;
                $tmp_lines = array();
                foreach (file($error_file) as $line => $source) {
                    if (($line + 1) >= $start_line) {
                        if (($line + 1) == $error_line) {
                            $tmp_lines[] = '<span style="color: #FF0000">Line ' . ($line + 1) . ': ' . htmlspecialchars($source) . '</span>';
                        } else {
                            $tmp_lines[] = 'Line ' . ($line + 1) . ': ' . htmlspecialchars($source);
                        }
                        if ($i >= $this->display_source_line) {
                            break;
                        }
                        $i++;
                    }
                }
                $_error_lines[$error['no']] = implode('', $tmp_lines);
            } else {
                $_error_lines[$error['no']] = '';
            }
        }

        SyL_Response::setStatusHeader('500');
        SyL_Response::setHeader('Content-Type', 'text/html; charset=' . SYL_ENCODE_INTERNAL);

        // ɽƤ
        ob_start();
        include_once SYL_ERROR_FORWARD_FILE;
        $contents = ob_get_clean();

        $response =& SyL_Response::singleton();
        $response->display($contents);
    }

    /**
     * ¸¾
     *
     * @access protected
     * @return string ¾
     */
    function extraLog()
    {
        $error_message  = '';
        if (isset($_SERVER['REQUEST_METHOD']))  $error_message .= 'REQUEST_METHOD: ' . $_SERVER['REQUEST_METHOD']  . $this->eol;
        if (isset($_SERVER['REQUEST_URI']))     $error_message .= 'REQUEST_URI: '    . $_SERVER['REQUEST_URI']     . $this->eol;
        if (isset($_SERVER['HTTP_REFERER']))    $error_message .= 'REFERRER: '       . $_SERVER['HTTP_REFERER']    . $this->eol;
        if (isset($_SERVER['HTTP_USER_AGENT'])) $error_message .= 'USER_AGENT: '     . $_SERVER['HTTP_USER_AGENT'] . $this->eol;
        $error_message .= 'GET : '  . print_r($_GET, true);
        $error_message .= 'POST : ' . print_r($_POST, true);
        return $error_message;
    }

}

?>
