<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.19 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥ᡼ե졼ͤ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.19 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterParameter extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = '.';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access protected
     * @param object ꥯȥ֥
     */
    function createActionInfo(&$data)
    {
        $pathinfo = array();
        // ѥ᡼ SYL_ACTION_KEY Ǽѥ᡼
        $action   = $data->get(SYL_ACTION_KEY);
        if (is_array($action)) {
            if (count($action) > 0) {
                $pathinfo = explode($this->action_delimiter, $action[0]);
            }
        } else {
            $pathinfo = explode($this->action_delimiter, $action);
        }

        switch (count($pathinfo)) {
        case 0:
            $this->action_method = '';
            $this->action_file   = '/' . ucfirst($this->action_file_default);
            break;
        case 1:
            $this->action_method = array_pop($pathinfo);
            $this->action_file   = '/' . ucfirst($this->action_file_default);
            break;
        default:
            $this->action_method = array_pop($pathinfo);
            $this->action_file   = '/' . implode('/', array_map('ucfirst', $pathinfo)) . $this->exe_ext;
            array_pop($pathinfo); // ե̾
            break;
        }

        // ƥץ졼ȥե
        $this->template_file = substr($this->action_file, 0, intval('-' . strlen($this->exe_ext))) . SYL_ROUTER_URL_EXT;
        // 饹ե
        $this->action_class = $this->createActionClass($this->action_file);
    }

}

?>
