<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPgsql.php,v 1.2 2007/11/04 13:44:14 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹PostgreSQL
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPgsql.php,v 1.2 2007/11/04 13:44:14 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverPgsql extends SyL_DB
{
    /**
     * 󥳡Ѵơ֥
     *
     *  PostgreSQL <=> PHP
     *  (client)       (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'euc-jp'),
      array('euc-jp',    'euc-jp'),
      array('euc',       'euc-jp'),
      array('sjis-win',  'sjis' ),
      array('sjis-win',  'mskanji'),
      array('sjis-win',  'shiftjis'),
      array('sjis-win',  'win932'),
      array('sjis-win',  'windows932'),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8'),
      array('utf-8',     'unicode')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_array   = array();
        $conn_array[] = 'dbname=' . $dbname;
        $conn_array[] = 'user='   . $user;
        if ($passwd != '') {
            $conn_array[] = 'password=' . $passwd;
        }
        if ($host != '') {
            $conn_array[] = 'host=' . $host;
        }
        if ($port != '') {
            $conn_array[] = 'port=' . $port;
        }
        $conn_string = implode(' ', $conn_array);

        $this->connection = $persistent ? pg_pconnect($conn_string) : pg_connect($conn_string);
        if (is_resource($this->connection)) {
            $this->setDsnInfo($dbname, $user, $passwd, $host, $port, $persistent);
            return true;
        } else {
            return false;
        }
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            pg_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    function setClientEncoding($client_encode, $server_encode='')
    {
        $client_encode2 = strtolower($client_encode);
        foreach ($this->encode_table as $encode_table) {
            if ($encode_table[0] == $client_encode2) {
                $client_encode2 = $encode_table[1];
                break;
            }
        }
        pg_set_client_encoding($this->connection, $client_encode2);
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $error_message = $this->connection ? pg_last_error($this->connection) : pg_last_error();
            if ($error_message != '') {
                $this->last_error_code    = '9999';
                $this->last_error_message = $error_message;
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return pg_escape_string($parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        @pg_query($this->connection, 'BEGIN');
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        @pg_query($this->connection, 'ROLLBACK');
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @pg_query($this->connection, 'COMMIT');
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        // ¹Ի顼Ƚ
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return pg_affected_rows($result);
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        // ¹Ի顼Ƚ
        $result = @pg_query($this->connection, $sql);
        if ($result !== false) {
            return true;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }
  
    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);
  
        // Ƚ
        if (!is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        // 1ե
        case 'one':
            if (pg_num_rows($query) > 0) {
                list($data) = pg_fetch_row($query);
            } else {
                $data = '';
            }
            break;
        // 1쥳
        case 'record':
            $data = pg_fetch_assoc($query);
            if ($data === false) {
                $data = array();
            } else {
                $data = $this->caseFieldName($data);
            }
            break;
        // 쥳
        case 'all':
            $data = array();
            while ($result = pg_fetch_assoc($query)) {
                $data[] = $this->caseFieldName($result);
            }
            break;
        }
        pg_free_result($query);
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= " LIMIT "  . $pager->getCount();
        $sql_page .= " OFFSET " . $pager->getStartOffset();

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * @access public
     * @return int Ǹ줿ԤID
     */
    function lastInsertId($seq='')
    {
        $sql = "SELECT CURRVAL('{$seq}')";
        $this->queryRef($sql, $data, 'one');
        return $data;
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    function getVersion()
    {
        $sql = "SELECT VERSION()";
        $this->queryRef($sql, $version, 'one');
        if (preg_match('/^PostgreSQL (.+) on .+$/', trim($version), $matches)) {
            $version = $matches[1];
        }
        return $version;
    }
}

?>
