<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Filesystem.php,v 1.2 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * t@CVXẽfBNgNX
 */
require_once dirname(__FILE__) . '/Filesystem/SyL_FilesystemDirectory.php';
/**
 * t@CVXẽt@CNX
 */
require_once dirname(__FILE__) . '/Filesystem/SyL_FilesystemFile.php';
/**
 * sNX
 */
require_once dirname(__FILE__) . '/Util/SyL_UtilEnv.php';

/**
 * t@CVXeNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Filesystem.php,v 1.2 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Filesystem
{
    /**
     * vf
     *
     * @access protected
     * @var string
     */
    var $name = '';
    /**
     * vf^Cv
     *
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * vf̃^f[^
     *
     * @access protected
     * @var array
     */
    var $stat = array();

    /**
     * RXgN^
     *
     * @access public
     * @param string vfi΃pXj
     */
    function SyL_Filesystem($name)
    {
        if (preg_match('/^(.+)(\\\\|\/)$/', $name)) {
            $name = substr($name, 0, -1);
        }
        // t@CZbg
        $this->name = $name;
        // t@C^Cv
        $this->type = filetype($name);
        // vf擾
        $this->getStats();
    }

    /**
     * vfIuWFNg擾
     *
     * @static
     * @access public
     * @param string vfi΃pXj
     */
    function &factory($file)
    {
        if (!file_exists($file)) {
            trigger_error("[SyL error] File not found ({$file})", E_USER_ERROR);
        }

        clearstatcache();
        $file = realpath($file);

        $element = null;
        if (is_dir($file)) {
           $element =& new SyL_FilesystemDirectory($file);
        } else {
           $element =& new SyL_FilesystemFile($file);
        }
        return $element;
    }

    /**
     * fBNg
     *
     * @access public
     * @return bool true: fBNgAfalse: fBNgȊO
     */
    function isDir()
    {
        return false;
    }

    /**
     * ݔ
     *
     * @access public
     * @return bool true: fBNgAfalse: fBNgȊO
     */
    function isWritable()
    {
        return is_writable($this->name);
    }

    /**
     * vf擾
     *
     * @access public
     * @param bool vf̂ݎ擾tO
     * @return string vf
     */
    function getName($name_only=false)
    {
        return ($name_only) ? basename($this->name) : $this->name;
    }

    /**
     * vf^Cv擾
     *
     * @access public
     * @return string vf^Cv
     */
    function getType()
    {
        return $this->type;
    }

    /**
     * vf̃^f[^擾
     *
     * @access public
     * @param string vf
     * @return mixed vfl
     */
    function getStat($name)
    {
        return isset($this->stat[$name]) ? $this->stat[$name] : null;
    }

    /**
     * SĂ̗vf̃^f[^擾
     *
     * @access protected
     * @return array 
     */
    function getStats()
    {
        $stat = array();
        if ($this->exists()) {
            $name = $this->name;
            // ^f[^擾
            $stat = stat($name);
            for ($i=0; $i<13; $i++) {
                unset($stat[$i]);
            }
        }
        $this->stat = $stat;
    }

    /**
     * vfXg擾
     *
     * @access public
     * @return mixed vfIuWFNgi̔zj
     */
    function getList()
    {
    }

    /**
     * TCY擾
     *
     * @access protected
     * @return int TCY
     */
    function getSize()
    {
        return isset($this->stat['size']) ? $this->stat['size'] : null;
    }

    /**
     * TCYifBNg̑St@CTCYj擾
     *
     * @access protected
     * @return int TCY
     */
    function getSizeAll()
    {
        return $this->getSize();
    }

    /**
     * ŏIXV擾
     *
     * @access public
     * @return string ŏIXV
     */
    function getMtime()
    {
        if (isset($this->stat['mtime'])) {
            return date('Y-m-d H:i:s', $this->stat['mtime']);
        } else {
            return null;
        }
    }

    /**
     * vf݂邩`FbN
     *
     * @access protected
     * @return bool true: ݂Afalse: ݂Ȃ
     */
    function exists()
    {
        return file_exists($this->name);
    }

    /**
     * vfǉ
     *
     * @access public
     * @param object vfIuWFNg
     */
    function add($element)
    {
    }

    /**
     * vf폜
     *
     * @access public
     * @return bool true: 폜OKAfalse: 폜G[
     */
    function delete()
    {
    }

    /**
     * vfύX
     *
     * @access public
     * @param string Vt@Ci΃pXj
     * @return bool true: ύXOKAfalse: ύXG[
     */
    function rename($new_filename)
    {
        if (rename($this->name, $new_filename)) {
            $this->name = $new_filename;
            return true;
        } else {
            return false;
        }
    }

    /**
     * fBNgKw擾
     *
     * @access public
     * @param int sőKw
     */
    function createTree($limit_depth=1)
    {
    }

    /**
     * vf
     *
     * @access public
     * @param string t@C
     * @param int sőKw
     */
    function searchTree($word, $limit_depth=1)
    {
        return array();
    }

    /**
     * p[~bV𐮌`
     *
     * @access public
     * @param int p[~bV
     * @param bool 8i擾tO
     * @return string `̃p[~bV
     */
    function getPermission($numeric=true)
    {
        $perm = fileperms($this->name);
        if ($numeric) {
            return substr(sprintf('%o', $perm), -4);
        } else {
            $info  = '';
            if (($perm & 0xC000) == 0xC000) {
                $info = 's'; // \Pbg
            } else if (($perm & 0xA000) == 0xA000) {
                $info = 'l'; // V{bNN
            } else if (($perm & 0x8000) == 0x8000) {
                $info = '-'; // ʏ̃t@C
            } else if (($perm & 0x6000) == 0x6000) {
                $info = 'b'; // ubNXyVt@C
            } else if (($perm & 0x4000) == 0x4000) {
                $info = 'd'; // fBNg
            } else if (($perm & 0x2000) == 0x2000) {
                $info = 'c'; // LN^XyVt@C
            } else if (($perm & 0x1000) == 0x1000) {
                $info = 'p'; // FIFO pCv
            } else {
                $info = 'u'; // s
            }

            // L
            $info .= ($perm & 0x0100) ? 'r' : '-';
            $info .= ($perm & 0x0080) ? 'w' : '-';
            $info .= ($perm & 0x0040)
                   ? (($perm & 0x0800) ? 's' : 'x')
                   : (($perm & 0x0800) ? 'S' : '-');
            // O[v
            $info .= ($perm & 0x0020) ? 'r' : '-';
            $info .= ($perm & 0x0010) ? 'w' : '-';
            $info .= ($perm & 0x0008)
                   ? (($perm & 0x0400) ? 's' : 'x')
                   : (($perm & 0x0400) ? 'S' : '-');
            // S
            $info .= ($perm & 0x0004) ? 'r' : '-';
            $info .= ($perm & 0x0002) ? 'w' : '-';
            $info .= ($perm & 0x0001)
                   ? (($perm & 0x0200) ? 't' : 'x')
                   : (($perm & 0x0200) ? 'T' : '-');
            return $info;
        }
    }

    /**
     * p[~bVύX
     *
     * @access public
     * @param int p[~bVi8i : 0755j
     * @return bool true: ύXAfalse: G[
     */
    function changePermission($perm)
    {
        return chmod($this->name, $perm);
    }

    /**
     * vf̏LҖ擾
     *
     * @access public
     * @return string LҖ
     */
    function getOwner()
    {
        return isset($this->stat['uid']) ? SyL_UtilEnv::getOsUser($this->stat['uid']) : null;
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂gp\eʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gp\e
     */
    function getFreeSpace($dir)
    {
        return disk_free_space($dir);
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂gpςݗeʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gpςݗe
     */
    function getUsedSpace($dir)
    {
        $class = __CLASS__;
        $free  = call_user_func(array($class, 'getFreeSpace'),  $dir);
        $total = call_user_func(array($class, 'getTotalSpace'), $dir);
        return ($total - $free);
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂鑍eʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gpςݗe
     */
    function getTotalSpace($dir)
    {
        return disk_total_space($dir);
    }

    /**
     * eʕ\𐮌`
     *
     * @static
     * @access public
     * @param int e
     * @param int ̌
     * @return string `e
     */
    function formatSize($size, $suffix='KB', $number=0)
    {
        switch (strtoupper($suffix)) {
        case 'TB': $size /= 1099511627776; break;
        case 'GB': $size /= 1073741824; break;
        case 'MB': $size /= 1048576; break;
        case 'KB': $size /= 1024; break;
        }
        return number_format(round($size, $number)) . $suffix;
    }

    /**
     * eʕ\₷悤ɐ`
     *
     * @static
     * @access public
     * @param int e
     * @param int ̌
     * @return string `e
     */
    function formatVisualSize($size, $number=0)
    {
        $suffix = 'B';
        if ($size > 1099511627776) {
            $size /= 1099511627776;
            $suffix = 'TB';
        } else if ($size > 1073741824) {
            $size /= 1073741824;
            $suffix = 'GB';
        } else if ($size > 1048576) {
            $size /= 1048576;
            $suffix = 'MB';
        } else if ($size > 1024) {
            $size /= 1024;
            $suffix = 'KB';
        }
        return number_format(round($size, $number)) . $suffix;
    } 
}

?>
