<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.19 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.19 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Router
{
    /**
     * 롼ƥե̾
     * 
     * @access private
     * @param string
     */
    var $router_file_name = 'routers.xml';
    /**
     * ǥեȥե̾
     * Ƭʸ
     *
     * @access protected
     * @var string
     */
    var $action_file_default = 'Index.php';
    /**
     * URLγĥ
     *
     * @access protected
     * @var string
     */
    var $url_ext = SYL_ROUTER_URL_EXT;
    /**
     * ¹ԥեγĥ
     *
     * @access protected
     * @var string
     */
    var $exe_ext = '.php';
    /**
     * ե
     *
     * @access protected
     * @var string
     */
    var $action_file = '';
    /**
     * ƥץ졼ȥե
     *
     * @access protected
     * @var string
     */
    var $template_file = '';
    /**
     * ᥽å̾
     *
     * @access protected
     * @var string
     */
    var $action_method = '';
    /**
     * 饹̾
     *
     * @access protected
     * @var string
     */
    var $action_class = '';
    /**
     * ӥ塼
     *
     * @access protected
     * @var string
     */
    var $view_type = '';
    /**
     * 쥤̾
     *
     * @access protected
     * @var string
     */
    var $layout_name = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 
     */
    function SyL_Router()
    {
    }

    /**
     * ܾ󥪥֥Ȥ
     *
     * @static
     * @access public
     * @param object ȥ饪֥
     * @param object ǡ֥
     * @param string ܾ󥪥֥̾
     * @return object ܾ󥪥֥
     */
    function &factory(&$controller, &$data, $rule)
    {
        $classname = 'SyL_Router' . ucfirst($rule);
        include_once SYL_INCLUDE_DIR . "/framework/Router/{$classname}.php";
        $router =& new $classname();
        $router->createActionInfo($data);
        // եѥå
        if (!$router->validAction()) {
            SyL_Response::forward404();
        }
        $router->changeRoutingConfig($controller);
        return $router;
    }

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * $this->action_method
     * $this->action_file
     * $this->action_class
     *
     * @access protected
     * @param object ꥯȥ֥
     */
    function createActionInfo(&$data)
    {
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return $this->action_file;
    }

    /**
     * ƥץ졼ȥե
     *
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        return $this->template_file;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return $this->action_class;
    }

    /**
     * ᥽å̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return $this->action_method;
    }

    /**
     * ӥ塼פ
     *
     * @access public
     * @return string ӥ塼
     */
    function getViewType()
    {
        return $this->view_type;
    }

    /**
     * 쥤̾
     *
     * @access public
     * @return string 쥤̾
     */
    function getLayoutName()
    {
        return $this->layout_name;
    }

    /**
     * 롼ƥŬ
     *
     * @access protected
     * @param object ƥȥ֥
     * @param object ǡ֥
     */
    function changeRoutingConfig(&$controller)
    {
        $config_files = array();
        $config_files[] = SYL_APP_CONFIG_DIR . "/{$this->router_file_name}";
        if (!is_file($config_files[0])) {
            return;
        }

        $config =& SyL_Config::factory('routers', $config_files, $controller);
        $config->parseXml();
        foreach ($config->getConfig() as $action => $router) {
            $action = str_replace('/', '\\/', $action); 
            if (preg_match('/^(' . $action . ')$/', $this->action_file)) {
                if ($router['enableAction']) {
                    if (isset($router['forwardAction']) && ($router['forwardAction'] !== '')) {
                        $this->action_file  = $router['forwardAction'];
                        $this->action_class = $this->createActionClass($this->action_file);
                    }
                }
                if ($router['enableTemplate']) {
                    if (isset($router['forwardAction']) && ($router['forwardAction'] !== '')) {
                        $this->template_file = substr($router['forwardAction'], 0, intval('-' . strlen($this->exe_ext))) . SYL_ROUTER_URL_EXT;
                    }
                }
                $this->view_type   = $router['viewType'];
                $this->layout_name = $router['layoutName'];
                break;
            }
        }
    }

    /**
     * եΥѥå
     * ǥ쥯ȥ꡿եƬ_פϥԲ
     *
     * @access public
     * @return bool true: ͭfalse: ̵
     */
    function validAction()
    {
        foreach (explode('/', $this->action_file) as $tmp) {
            if (substr($tmp, 0, 1) == '_') {
                return false;
            }
        }
        return true;
    }

    /**
     * 󥯥饹̾
     *
     * @access protected
     * @param string ե
     * @return string 󥯥饹̾
     */
    function createActionClass($action_file)
    {
        $classname = str_replace('/', '_', substr($action_file, 1));
        return preg_replace('/(' . preg_quote($this->exe_ext) . ')$/', '', $classname);
    }
}

?>
