<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementDate.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եǥ롼ץ饹
 */
require_once 'SyL_FormElementGroup.php';

/**
 * ɽǥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementDate.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementDate extends SyL_FormElementGroup
{
    /**
     * ե̾
     *
     * @access private
     * @var string
     */
    var $form_name = '';
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;/&nbsp;";

    /**
     * ե४֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object ե४֥
     */
    function initGroup(&$form)
    {
        $this->form_name = $form->getAttribute('name');

        $y_name = $this->attributes['year'];
        $m_name = $this->attributes['month'];
        $d_name = $this->attributes['day'];

        $selected_year = $form->getParameter($y_name);
        $selected_month = $form->getParameter($m_name);
        $selected_day   = $form->getParameter($d_name);

        if (is_array($selected_year)  && (count($selected_year) > 0))  $selected_year  = $selected_year[0];
        if (is_array($selected_month) && (count($selected_month) > 0)) $selected_month = $selected_month[0];
        if (is_array($selected_day)   && (count($selected_day) > 0))   $selected_day   = $selected_day[0];

        $years  = array('' => '----');
        $months = array('' => '--');
        $days   = array('' => '--');

        $years += $this->options;
        if ($selected_year) {
            for ($i=1; $i<=12; $i++) {
                $tmp = ($i < 10) ? '0' . $i : (string)$i;
                $months[$tmp] = $tmp;
            }
            if ($selected_month) {
                $max_day = date('t', mktime(0, 0, 0, $selected_month, 1, $selected_year));
                for ($i=1; $i<=$max_day; $i++) {
                    $tmp = ($i < 10) ? '0' . $i : (string)$i;
                    $days[$tmp] = $tmp;
                }
            }
        }

        $attributes = array();
        $attributes['onChange']  = '';
        $attributes['onChange'] .= "sylChangeDate(";
        $attributes['onChange'] .= "this.form.elements['{$y_name}[]'],";
        $attributes['onChange'] .= "this.form.elements['{$m_name}[]'],";
        $attributes['onChange'] .= "this.form.elements['{$d_name}[]'],";
        $attributes['onChange'] .= "this.form.elements['{$y_name}[]'].options[this.form.elements['{$y_name}[]'].selectedIndex].value,";
        $attributes['onChange'] .= "this.form.elements['{$m_name}[]'].options[this.form.elements['{$m_name}[]'].selectedIndex].value,";
        $attributes['onChange'] .= "this.form.elements['{$d_name}[]'].options[this.form.elements['{$d_name}[]'].selectedIndex].value";
        $attributes['onChange'] .= ")";

        $this->addElement($form->createElement('select', $y_name, $this->getDisplayName(), $years,  $attributes));
        $this->addElement($form->createElement('select', $m_name, $this->getDisplayName(), $months, $attributes));
        $this->addElement($form->createElement('select', $d_name, $this->getDisplayName(), $days,   $attributes));

        $this->setSeparator($this->separator);
    }

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;

        $format = '%s' . $this->separator . '%s' . $this->separator . '%s';
        $this->setFormat($format, $this->attributes['year'], $this->attributes['month'], $this->attributes['day']);
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        static $js_change_date = false;
        $html = parent::getHtmlTag();
        if (!$js_change_date) {
            $html .= $this->getJsChangeDateFunc();
            $js_change_date = true;
        }

        $html .= $this->getJsChangeDate();
        return $html;
    }

    /**
     * ѹJavaScript
     *
     * @access public
     * @return string ѹJavaScript
     */
    function getJsChangeDate()
    {
        $dates  = $this->getValue();
        $y_name = $this->attributes['year'];
        $m_name = $this->attributes['month'];
        $d_name = $this->attributes['day'];
        $y_value = isset($dates[$y_name]) ? array_shift($dates[$y_name]) : '';
        $m_value = isset($dates[$m_name]) ? array_shift($dates[$m_name]) : '';
        $d_value = isset($dates[$d_name]) ? array_shift($dates[$d_name]) : '';

        return <<< JS_CHANGE_DATE
<script type="text/javascript">
<!--
sylChangeDate(document.{$this->form_name}.elements['{$y_name}[]'], document.{$this->form_name}.elements['{$m_name}[]'], document.{$this->form_name}.elements['{$d_name}[]'], '{$y_value}', '{$m_value}', '{$d_value}');
//-->
</script>
JS_CHANGE_DATE;
    }

    function getJsChangeDateFunc()
    {
        return <<< JS_CHANGE_DATE
<script type="text/javascript">
<!--
function sylChangeDate(y, m, d, yv, mv, dv)
{
  if (yv == '') {
    while(m.options.length) m.options[m.options.length - 1] = null;
    m.options[0] = new Option("--", "");
    while(d.options.length) d.options[d.options.length - 1] = null;
    d.options[0] = new Option("--", "");
    return;
  }

  if (mv == '') {
    while(m.options.length) m.options[m.options.length - 1] = null;
    m.options[0] = new Option("--", "");
    for (var month=1; month<=12; month++) {
      var tmp = (month <= 9) ? '0' + String(month) : String(month);
      m.options[m.options.length] = new Option(tmp, tmp);
    }
    while(d.options.length) d.options[d.options.length - 1] = null;
    d.options[0] = new Option("--", "");
    return;
  }

  var y_int = parseInt(yv, 10);
  var m_int = parseInt(mv, 10);

  var maxDay = 0;
  switch (parseInt(m_int, 10)) {
  case 4:
  case 6:
  case 9:
  case 11:
    maxDay = 30;
    break;
  case 2:
    if ((((y_int % 4) == 0) && (y_int % 100) != 0) || ((y_int % 400) == 0)) {
      maxDay = 29;
    } else {
      maxDay = 28;
    }
    break;
  default:
    maxDay = 31;
    break;
  }

  if (m.options.length != 13) {
    while(m.options.length) m.options[m.options.length - 1] = null;
    m.options[0] = new Option("--", "");
    for (var month=1; month<=12; month++) {
      var tmp = (month <= 9) ? '0' + String(month) : String(month);
      m.options[m.options.length] = new Option(tmp, tmp);
    }
    m.options[m_int].selected = true;
  }

  while(d.options.length) d.options[d.options.length - 1] = null;
  d.options[0] = new Option("--", "");
  for (var day=1; day<=maxDay; day++) {
    var tmp = (day <= 9) ? '0' + String(day) : String(day);
    d.options[d.options.length] = new Option(tmp, tmp);
  }

  if (dv != '') {
    d_int = parseInt(dv, 10);
    if (d_int > maxDay) d_int = maxDay;
    d.options[d_int].selected = true;
  }
}
//-->
</script>
JS_CHANGE_DATE;

    }
}

?>
