<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientResult.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPNGXgʃNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientResult.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_HttpClientResult
{
    /**
     * X|XXe[^X
     *
     * @access protected
     * @var string
     */
    var $status = '';
    /**
     * X|Xf[^
     *
     * @access protected
     * @var string
     */
    var $data = '';
    /**
     * X|Xwb_
     *
     * @access protected
     * @var array
     */
    var $headers = array();
    /**
     * X|X{
     *
     * @access protected
     * @var string
     */
    var $body = '';
    /**
     * ̕R[h
     *
     * @access protected
     * @var string
     */
    var $original_encode = '';
    /**
     * R[h
     *
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * s
     *
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * RXgN^
     * 
     * @access public
     * @param string NGXg
     * @param string NCAgGR[h
     */
    function SyL_HttpClientResult($data, $client_encode='')
    {
        $this->data = $data;
        $data       = explode($this->eol . $this->eol, $data, 2);
        $compress   = '';
        foreach (explode($this->eol, $data[0]) as $header) {
          $header = trim($header);
          if (preg_match('/^Content-Type:(.+)charset\=([^ ]+)(.*)/i', $header, $matches)) {
              $this->original_encode = trim($matches[2]);
          } else if (preg_match('/^Content-Encoding:(.+)/i', $header, $matches)) {
              $compress = trim($matches[1]);
          } else if (preg_match('/^Transfer-Encoding:[ ]*chunked$/i', $header)) {
              if (isset($data[1])) {
                  $body = '';
                  while (true) {
                      if (preg_match('/^([0-9a-fA-F]+)[ ]*(\r\n|\r|\n)(.+)$/s', ltrim($data[1]), $matches)) {
                          if ($matches[1] == '0') {
                              break;
                          }

                          $bytes    = hexdec($matches[1]);
                          $body    .= substr($matches[3], 0, $bytes);
                          $data[1]  = substr($matches[3], $bytes+1);
                      } else {
                          break;
                      }
                  }
                  $data[1] = $body;
              }
          } else if (preg_match('/^HTTP\/1\.[01] ([^ ]+) (.*)$/', $header, $matches)) {
              $this->status = $matches[1];
          }
          $this->headers[] = $header;
        }
        if (isset($data[1])) {
            switch ($compress) {
            case 'gzip':    $this->body = gzuncompress($data[1]); break;
            case 'deflate': $this->body = gzinflate($data[1]);    break;
            default:        $this->body = $data[1];
            }
        }
        if ($client_encode) {
            $this->client_encode = $client_encode;
        }
        if (!$this->client_encode) {
            $this->client_encode = mb_internal_encoding();
        }
    }

    /**
     * R[h擾
     * 
     * @access public
     * @return string R[h
     */
    function getClientEncode()
    {
        return $this->client_encode;
    }

    /**
     * X|XXe[^X擾
     * 
     * @access public
     * @return string X|XXe[^X
     */
    function getResponseStatus()
    {
        return $this->status;
    }

    /**
     * X|Xf[^擾
     * 
     * @access public
     * @return string X|Xf[^
     */
    function getResponseData()
    {
        return $this->data;
    }

    /**
     * X|Xwb_mF
     * 
     * @access public
     * @param string X|Xwb_
     * @return bool true: X|Xwb_Afalse: X|Xwb_
     */
    function isHeader($name)
    {
        foreach ($this->headers as $header) {
            $reg = '/^' . preg_quote($name, '/') . '/';
            if (preg_match($reg, $header)) {
                return true;
            }
        }
        return false;
    }

    /**
     * X|Xwb_擾
     * 
     * @access public
     * @param string X|Xwb_
     * @return array X|Xwb_
     */
    function getHeader($name)
    {
        $headers = array();
        foreach ($this->headers as $header) {
            $reg = '/^' . preg_quote($name, '/') . ': (.+)/';
            if (preg_match($reg, $header, $matches)) {
                $headers[] = $matches[1];
            }
        }
        return $headers;
    }

    /**
     * X|X{擾
     * 
     * @access public
     * @return string X|X{
     */
    function getResult()
    {
        return $this->body;
    }

}


?>
