<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendSmtp.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * å³饹
 */
require_once dirname(__FILE__) . '/../../SyL_Socket.php';

/**
 * SMTP᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendSmtp.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSendSmtp extends SyL_MailSend
{
    /**
     * åȥ饹
     *
     * @access private
     * @var object
     */
    var $socket = null;
    /**
     * SMTPޥɥ
     *
     * @access private
     * @var string
     */
    var $command_log = '';

    /**
     * ᡼륵С³
     *
     * @access public
     * @return OK: true, NG: false
     */
    function connect()
    {
        if (is_object($this->socket)) {
            $this->quit();
        }
        // åȥ֥Ⱥ
        $this->socket = new SyL_Socket($this->host, $this->port);
        $this->socket->setCommandCallBackFunc(array(&$this, 'receiveMessage'));

        // ǰΤ
        register_shutdown_function(array(&$this, 'quit'));

        if (!$this->socket->open()) {
            $this->error_message = $this->socket->getLastError();
            return false;
        } else {
            // ³å
            $this->socket->receive();
            // å
            $this->socket->send('HELO ' . $this->host);
            // å
            $this->socket->receive();

            // SMTP AUTH Ƚ
            if (!$this->isError() && ($this->user !== '')) {
                // ǧھ
                $this->socket->send('AUTH PLAIN ' . base64_encode("{$this->user}\0{$this->user}\0{$this->passwd}"));
                // ǧڷ̼
                $this->socket->receive();
            }
        }

        return !$this->isError();
    }

    /**
     * ᡼¹
     *
     * @access public
     * @param object ᡼å֥
     * @return OK: true, NG: false
     */
    function send($message)
    {
        $from = $message->getFrom();
        $to   = $message->getTo();

        if (count($from) == 0) {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        if (count($to) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // åȺȽ
        $once = false;
        if ($this->socket == null) {
            $once = true;
            $this->connect();
        }

        // ޥȯ ------------------------------------------------------------

        // åȥå
        $this->socket->send('MAIL FROM: ' . $from[0]);
        // åȥå
        $this->socket->receive();

        foreach ($message->getRcptTo() as $to) {
            // 襻åȥå
            $this->socket->send('RCPT TO: ' . $to);
            // 襻åȥå
            $this->socket->receive();
        }

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // ᡼إå ----------------------------------------------------------

        // ǡåȥå
        $this->socket->send('DATA');
        // ǡåȥå
        $this->socket->receive();

        // ᡼إåޤʸ
        $data = $message->getMessage(true);
        // Ǹˡ.פղ
        $data .= '.';

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // -------------------------------------------------------------------------

        // ǡåȥå
        $this->socket->send($data);
        // ǡåȥå
        $this->socket->receive();

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // ꥻåȥå
        $this->socket->send('RSET');
        // ꥻåȥå
        $this->socket->receive();

        if ($once) {
            $this->quit();
        }

        return true;
    }

    /**
     * ᡼륵СȤ³Ĥ
     *
     * @access public
     */
    function quit()
    {
        if (is_object($this->socket)) {
            // λå
            $this->socket->send('QUIT');
            // λå
            $this->socket->receive();
            // åȤĤ
            $this->socket->close();
        }

        $this->socket = null;
    }

    /**
     * SMTPޥɼå
     *
     * @access private
     * @param string send or receive
     * @param string ޥɥå
     */
    function receiveMessage($type, $message)
    {
        $message = trim($message);
        $this->command_log .= "[{$type}] {$message}\n";
        if ($type == 'receive') {
            if (preg_match('/^[4|5][0-9]{2}/', $message)) {
                $this->error_message = "[SyL error] SMTP command error ($message)";
            }
        }
    }

    /**
     * åȥޥɼ
     *
     * @access public
     * @return string åȥޥɼ
     */
    function getCommandLog()
    {
        return $this->command_log;
    }
}

?>
