<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClient.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTP饤ȥ饹
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClient.php';
/**
 * XMLRPC饤ȥѥ᡼饹
 */
require_once 'SyL_XmlRpcClientParameter.php';

/**
 * XML RPC饤ȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClient.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClient extends SyL_HttpClient
{
    /**
     * ѥ᡼֥Ȥ
     * 
     * @access protected
     * @param string XML RPC᥽å
     * @param string ꥯURL
     * @param string ꥯȥ᥽å
     */
    function &createParameter($rpc_method, $url='/', $method='POST')
    {
        $parameter =& new SyL_XmlRpcClientParameter($url, $method);
        $parameter->setMethod($rpc_method);
        return $parameter;
    }

    /**
     * ̥֥Ȥ
     * 
     * @access protected
     * @param string 쥹ݥ󥹥ǡ
     * @param string 饤ȥ󥳡
     */
    function &createResult(&$data, $client_encode='')
    {
        include_once 'SyL_XmlRpcClientResult.php';
        $result =& new SyL_XmlRpcClientResult($data, $client_encode);
        return $result;
    }

}

?>
