<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientParameter.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCѥꥯȺ饹
 */
require_once 'SyL_XmlRpcBuilderClient.php';

/**
 * XMLRPC饤ȥѥ᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientParameter.php,v 1.4 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientParameter extends SyL_HttpClientParameter
{
    /**
     * XMLRPCѥꥯȺ饹
     *
     * @access private
     * @var object
     */
    var $builder = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string HTTPꥯоURL
     * @param string ꥯȥ᥽å
     */
    function SyL_XmlRpcClientParameter($url='/', $method='POST')
    {
        parent::SyL_HttpClientParameter($url, $method);
        $this->setHeader('content-type', 'text/xml');
        $this->builder =& new SyL_XmlRpcBuilderClient();
    }

    /**
     * ᥽å̾򥻥å
     * 
     * @access public
     * @param string ᥽å̾
     */
    function setMethod($method_name)
    {
        $this->builder->setMethod($method_name);
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼
     * @param string 
     */
    function set($value, $format='')
    {
        $this->builder->set($value, $format);
    }

    /**
     * ѥ᡼ꥯȷѴ
     * 
     * @access public
     * @return string XMLǡ
     */
    function build()
    {
        return $this->builder->build();
    }

}

?>
