<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.7 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptϥե졼饹
 */
require_once 'SyL_ContextJs.php';

/**
 * WEBץꥱե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.7 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ContextWeb extends SyL_ContextJs
{
    /**
     * ӥ塼
     * 
     * @access protected
     * @var string
     */
    var $view_type = 'default';
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * 쥤̾
     * 
     * @access private
     * @var string
     */
    var $layout_name = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     * @param object ǡ֥
     */
    function SyL_ContextWeb(&$controller, &$data)
    {
        $router =& SyL_Router::factory($controller, $data, SYL_ROUTER_RULE);
        $this->setActionFile($router->getActionFile());
        $this->setClassName($router->getClassName());
        $this->setActionName($router->getActionName());
        $this->setTemplateFile($router->getTemplateFile());
        $view_type = $router->getViewType();
        if ($view_type !== '') {
            $this->setViewType($view_type);
        }
        $layout_name = $router->getLayoutName();
        if ($layout_name !== '') {
            $this->setLayoutName($layout_name);
        }

        $this->controller =& $controller;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥե򥻥åȡʥإѡ
     * ǻ
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplate($template)
    {
        $pos = strrpos($this->template_file, '.');
        if ($pos === false) {
            trigger_error("[SyL error] Template file extension not found ({$this->template_file})", E_USER_ERROR);
        }
        $ext = substr($this->template_file, $pos+1);
        $this->template_file = SyL_Loader::convertPath($template, $ext);
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->controller->getTemplateDir() . '/';
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @param bool 404顼ưե饰
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile($trigger_error_404=true)
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->template_file;
        if (preg_match('/^(\\\\|\/)(.+)$/', $template_file, $matches)) {
            $template_file = $matches[2];
        }

        // ǥХå - ƥץ졼Ȥξ
        SyL_Loggers::debug("Template dir: {$template_dir} file: {$template_file}");

        // ƥץ졼ȥե¸ߥå
        if ($trigger_error_404 && !is_file($template_dir . $template_file)) {
            SyL_Loggers::warn("Template file not found dir: {$template_dir} file: {$template_file}");
            SyL_Response::forward404();
        }
        return $template_file;
    }

    /**
     * 쥤̾򥻥å
     *
     * @access public
     * @return string 쥤̾
     */
    function setLayoutName($layout_name)
    {
        $this->layout_name = $layout_name;
    }

    /**
     * 쥤̾
     *
     * @access public
     * @return string 쥤̾
     */
    function getLayoutName()
    {
        return $this->layout_name;
    }

    /**
     * ɥե򥻥å
     *
     * ɥե̾ꤷʤϡContent-Disposition: inline ˤʤ
     * 
     * @access public
     * @param string ɥեѥ
     * @param string ɥե̾
     * @param string ƥĥ
     */
    function setDownloadFile($file, $filename='', $type='application/octet-stream')
    {
        $data = file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Download file ($file)", E_USER_ERROR);
        }
        $this->setDownloadData($data, $filename, $type);
    }

    /**
     * ɥǡ򥻥å
     * 
     * ɥե̾ꤷʤϡContent-Disposition: inline ˤʤ
     *
     * @access public
     * @param string ɥեѥ
     * @param string ɥե̾
     * @param string ƥĥ
     */
    function setDownloadData($data, $filename='', $type='application/octet-stream')
    {
        $this->setViewType('download');
        $this->setParameter('_download_name', $filename);
        $this->setParameter('_download_type', $type);
        $this->setParameter('_download_data', $data);
    }

    /**
     * ϲե򥻥å
     *
     * @access public
     * @param string եѥ
     * @param string ƥĥ
     */
    function setDisplayImageFile($file, $type='')
    {
        if (!$type) {
            $size = getimagesize($file);
            if (!$size || !isset($size['mime'])) {
                trigger_error("[SyL error] Image mime unable to get from getimagesize function ($file)", E_USER_ERROR);
            }
            $type = $size['mime'];
        }
        $data = @file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Image file ($file)", E_USER_ERROR);
        }
        $this->setDisplayImageData($data, $type);
    }

    /**
     * ϲǡ򥻥å
     *
     * @access public
     * @param string Хʥǡ
     * @param string ƥĥ
     */
    function setDisplayImageData($data, $type='')
    {
        $this->setViewType('image');
        $this->setParameter('_image_type',  $type);
        $this->setParameter('_image_data',  $data);
    }

    /**
     * XML֥ȡSyL_XmlWriterˤ򥻥å
     *
     * @access public
     * @param object XML֥
     * @param string ƥĥ
     */
    function setDisplayXml($rss_object, $type='text/xml')
    {
        $this->setViewType('xml');
        $this->setParameter('_xml_type',    $type);
        $this->setParameter('_xml_object',  $rss_object);
    }

    /**
     * RSS֥ȡSyL_XmlRssWriterˤ򥻥å
     *
     * @access public
     * @param object RSS֥
     * @param string ƥĥ
     */
    function setDisplayRss($rss_object, $type='text/xml')
    {
        $this->setViewType('rss');
        $this->setParameter('_rss_type',    $type);
        $this->setParameter('_rss_object',  $rss_object);
    }

    /**
     * 쥯URL򥻥å
     *
     * @access public
     * @param string 쥯URL
     */
    function setRedirectUrl($url)
    {
        $this->setViewType('redirect');
        $this->setParameter('_redirect_url', $url);
    }
}

?>
