<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.9 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.9 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJs extends SyL_View
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewJs(&$context, &$data)
    {
        parent::SyL_View($context, $data);
        // ƥĥפ򥻥å
        $this->setContentType('application/x-javascript; charset=' . SYL_ENCODE_INTERNAL);
    }

    /**
     * JavaScript򥤥ݡȤ
     * 
     * @access public
     */
    function importJs()
    {
    }

    /**
     * JavaScript󥰼¹
     * 
     * @access public
     */
    function render()
    {
        $this->importJs();
        // JavaScirpt
        $js  = $this->getJs();
        // ǡν
        $js .= $this->data->getJs();

        $this->setRender($js);
    }

    /**
     * JavaScript
     *
     * @access public
     * @return string JavaScript
     */
    function getJs()
    {
        $js = '';
        $imports = $this->data->getImport();
        if (count($imports) == 0) {
            return $js;
        }

        // ѥ᡼̾Ѵ
        foreach ($this->data->gets() as $name => $value) {
            $$name = $value;
        }

        // ץ¦ǥ쥯ȥ
        $paths1 = array();
        $paths1[] = SYL_APP_LIB_DIR;
        $paths1[] = SYL_PROJECT_LIB_DIR;

        // ե졼¦ǥ쥯ȥ
        $paths2 = array();
        $paths2[] = SYL_INCLUDE_DIR . "/lib";
        $paths3 = array();
        $paths3[] = SYL_INCLUDE_DIR . "/framework";

        ob_start();
        foreach ($imports as $mode) {
            $included = false;
            $file = SyL_Loader::convertPath($mode, 'js');
            foreach ($paths1 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
            if ($included) continue;

            $file = SyL_Loader::convertPathSyL("JsClient.{$mode}", 'js');
            foreach ($paths2 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
            if ($included) continue;

            foreach ($paths3 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
        }
        $js = ob_get_clean();

        // ǥȺ
        $js = preg_replace('/(\r\n|\r|\n)[ ]*/', "\n", $js);
        // Ⱥ
        //$js = preg_replace('/\/\*([^\/]*)\*\//s', "", $js);
        //$js = preg_replace('/\/\/([^(\r\n|\r|\n)]*)(\r\n|\r|\n)/', "", $js);

        return $js;
    }
}

?>
