<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheMemcache.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!defined('SYL_CACHE_MEMCACHE_HOST')) {
    define('SYL_CACHE_MEMCACHE_HOST', 'localhost:11211');
}

/**
 * Memcacheå奯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheMemcache.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_CacheMemcache extends SyL_Cache
{
    /**
     * memcache֥
     *
     * @access private
     * @var string
     */
    var $memcache = null;
    /**
     * å幹֤
     *
     * @access private
     * @var string
     */
    var $update_suffix = '_update';
    /**
     * Memcache̥ե饰
     *
     * @access private
     * @var int
     */
    var $compress = 0;

    /**
     * Memcached³
     *
     * @access public
     * @param string ۥ̾
     * @param int ݡֹ
     * @return bool true: false: 
     */
    function SyL_CacheMemcache($host='')
    {
        list($host, $port) = ($host) ? explode(':', $host, 2) : explode(':', SYL_CACHE_MEMCACHE_HOST, 2);

        static $singleton = array();
        if (!isset($singleton[$host.$port])) {
            $singleton[$host.$port] = new Memcache();
            if (!$singleton[$host.$port]->connect($host, $port)) {
                trigger_error("[SyL error] Unable to connect memcahed server ({$host}:{$port})", E_USER_ERROR);
            }
        }

        $this->memcache =& $singleton[$host.$port];
    }

    /**
     * MemcachedȤ³
     *
     * @access public
     */
    function close()
    {
        if ($this->memcache != null) {
            $this->memcache->close();
            $this->memcache = null;
        }
    }

    /**
     * åι֤򹹿
     *
     * @access public
     * @param int (UNIX Time)
     * @return bool true: OKfalse: 顼
     */
    function setModifyTime($mtime=0)
    {
        $key  = $this->getKey();
        $data = $this->memcache->get($key);
        if ($data) {
            $limit = 0;
            if ($this->life_time > 0) {
                $limit = ($mtime) ? $mtime - time() + $this->life_time : $this->life_time;
            }
            if ($this->memcache->replace($key, $data, $this->compress, $limit)) {
                if (!$mtime) {
                    $mtime = time();
                }
                $key_updaete = $key . $this->update_suffix;
                return $this->memcache->replace($key_updaete, $mtime, $this->compress, $limit);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * åեι֤
     *
     * @access public
     * @return int (UNIX Time)
     */
    function getModifyTime()
    {
        $key_updaete = $this->getKey() . $this->update_suffix;
        return $this->memcache->get($key_updaete);
    }

    /**
     * åɤ߹
     *
     * @access public
     * @param bool å֤ͭ򹹿
     * @return mixed åǡ
     */
    function read($modify_time_update=false)
    {
        $key = $this->getKey();
        $data = $this->memcache->get($key);
        if ($data !== false) {
            $key_updaete = $key . $this->update_suffix;
            $mtime = $this->memcache->get($key_updaete);
            // ֤κǾȽ
            if ($mtime && ($this->min_mtime > 0)) {
                if ($mtime < $this->min_mtime) {
                    $this->delete();
                    return false;
                }
            }
            // ֤κȽ
            if ($mtime && ($this->max_mtime > 0)) {
                if ($mtime > $this->max_mtime) {
                    $this->delete();
                    return false;
                }
            }

            if ($modify_time_update) {
                $this->setModifyTime();
            }
            return $data;
        } else {
            // åե̵ or ڤ
            return false;
        }
    }

    /**
     * å¸
     *
     * @access public
     * @param mixed åǡ
     * @return bool true: ¸false: ¸顼
     */
    function write($data)
    {
        $key = $this->getKey();
        if ($this->memcache->set($key, $data, $this->compress, $this->life_time)) {
            $key_updaete = $key . $this->update_suffix;
            $this->memcache->set($key_updaete, time(), $this->compress, $this->life_time);
            return true;
        } else {
            return false;
        }
    }

    /**
     * å
     * 
     * @access public
     * @return bool true: false: 顼
     */
    function delete()
    {
        $key         = $this->getKey();
        $key_updaete = $key . $this->update_suffix;
        $this->memcache->delete($key_updaete);
        return $this->memcache->delete($key);
    }

    /**
     * åδڤ쥭å
     *
     * @access public
     */
    function clean()
    {
        return true;
    }

    /**
     * åƺ
     *
     * @access public
     */
    function cleanAll()
    {
        $this->memcache->flush();
    }
}

?>
