/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * С¦SyL_FormElement饹
 * ϤХǡ᥽åɤޤ९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
function SyL_Validation(f)
{
  // ե४֥
  this.f = f;
}

SyL_Validation.prototype = {
  /**
   * ̤ϡ̤˥åԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isRequire: function(name, errorMessage, options)
  {
    // 顼å¹
    return this.validate(SyL_Validator.isRequire, name, options, errorMessage);
  },

  /**
   * ӥåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isCompare: function(name, errorMessage, options)
  {
    // ͼ
    if (options) {
      if (options['element']) {
        options['target'] = this.getValue(options['element']);
      } else {
        options['target'] = options['value'];
      }
    } else {
      return errorMessage;
    }
    // 顼å¹
    return this.validate(SyL_Validator.isCompare, name, options, errorMessage);
  },

  /**
   * ȾѿͥåԤ
   *
   * 0Ť, ǽ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isNumeric: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return '';
    }
    // 顼å¹
    return this.validate(SyL_Validator.isNumeric, name, options, errorMessage);
  },

  /**
   * ɽåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isRegex: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return '';
    }
    if (!options || !options['format']) {
      return errorMessage;
    }
    // 顼å¹
    return this.validate(SyL_Validator.isRegex, name, options, errorMessage);
  },

  /**
   * ХȿåԤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isLength: function(name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return '';
    }
    if (!options || !options['max']) {
      return errorMessage;
    }
    // 顼å¹
    return this.validate(SyL_Validator.isLength, name, options, errorMessage);
  },

  /**
   * դå
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   * @param object ץ
   * @return string 顼å
   */
  isDate: function (name, errorMessage, options)
  {
    // ̤Ϥξtrue
    if (this.isRequire(name, null, {'min_valids': '0', 'max_valids': '0'})) {
      return '';
    }
    // 顼å¹
    return this.validate(SyL_Validator.isDate, name, options, errorMessage);
  },

  /**
   * ڤ¹Ԥ
   *
   * @access private
   * @param object ¹Ԥؿ֥
   * @param mixed 
   * @param array ץ
   * @param string 顼å
   * @return true: OK, false: 顼
   */
  validate: function(func, name, options, errorMessage)
  {
    if (!options) {
      options = {};
    }

    // ͼ
    var value = this.getValue(name);

    var valid = true;
    if (value instanceof Array) {
      var min_valids = (options['min_valids']) ? options['min_valids'] : 0;
      var max_valids = (options['max_valids']) ? options['max_valids'] : 0;

      var ok = 0;
      var len = value.length;
      for (var i=0; i<len; i++) {
        if (func(value, options)) {
          ok++;
        }
      }

      if (max_valids == 0) {
        max_valids = len;
        if (min_valids == 0) {
          min_valids = len;
        }
      }
      valid = ((max_valids >= ok) && (min_valids <= ok));
    } else {
      valid = func(value, options);
      if (!valid) {
        if (options['min_error'] && options['min_error_message']) {
          errorMessage = options['min_error_message'];
        } else if (options['max_error'] && options['max_error_message']) {
          errorMessage = options['max_error_message'];
        }
      }
    }

    return valid ? '' : errorMessage;
  },

  /**
   * ͤ
   *
   * @access private
   * @param string ̾
   * @return mixed 
   */
  getValue: function(name)
  {
    var n = this.f.elements[name];
    var value = null;
    var type = '';
    if (this.f.elements[name][0] && this.f.elements[name][0].type) {
      type = this.f.elements[name][0].type;
    } else {
      type = this.f.elements[name].type;
    }

    switch (type) {
    case "select-one":
      var i = n.selectedIndex;
      if (i && i >= 0) {
        value = n.options[i].value;
      }
      break;
    case "select-multiple":
      value = [];
      for (var i=0; i<n.options.length; i++) {
        if (n.options[i].selected) {
          value.push(n.options[i].value);
        }
      }
      break;

    case "text":
    case "textarea":
    case "hidden":
    case "password":
      value = n.value;
      break;
    case "file":
      var len = n.length;
      if (len) {
        value = [];
        for (var i=0; i<len; i++) {
          value.push(n[i].value);
        }
      } else {
        value = n.value;
      }
      break;

    case "radio":
      var len = n.length;
      if (len) {
        for (var i=0; i<len; i++) {
          if (n[i].checked) {
            value = n[i].value;
            break;
          }
        }
      } else {
        if (n.checked) {
          value = n.value;
        }
      }
      break;
    case "checkbox":
      var len = n.length;
      if (len) {
        value = [];
        for (var i=0; i<len; i++) {
          if (n[i].checked) {
            value.push(n[i].value);
          }
        }
      } else {
        if (n.checked) {
          value = n.value;
        }
      }
      break;
    }

    return value;
  }

}

