<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML饹
 */
require_once dirname(__FILE__) . '/../Xml/SyL_XmlReader.php';

/**
 * WEBӥ쥹ݥ󥹥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceResponse extends SyL_XmlReader
{
    /**
     * 顼Ƚ
     * 
     * @access protected
     * @var bool
     */
    var $error = false;
    /**
     * 顼å
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string 쥹ݥ󥹥ơ
     * @param string ꥯȷXML
     * @param string С󥳡
     * @param string 饤ȥ󥳡
     */
    function SyL_WebServiceResponse($response_status, $result, $server_encode='UTF-8', $client_encode='')
    {
        if ($response_status != '200') {
            $this->error = true;
            $this->error_message = "status: {$response_status} ";
        }

        if ($server_encode) {
            $this->setXmlEncode($server_encode);
        }
        if ($client_encode) {
            $this->setClientEncode($client_encode);
        }
        $this->setData($result);
        $this->parseXml();
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * 顼Ƚ
     *
     * @access public
     * @return bool true: 顼ꡢfalse: 顼ʤ
     */
    function isError()
    {
        return $this->error;
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}

?>
