/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (typeof(SyL) == "undefined") {
  SyL = {};
}

/**
 * Ajax̿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
function SyL_Ajax()
{
  this.method      = 'GET';
  this.async       = true;
  this.loadingFunc = null;
  this.loadedFunc  = null;
  this.parameters  = {};
  this.request     = this.getXMLHttpObject();
  this.timeout     = 60000;
  this.callback_parameter_name = "callback";
}

SyL_Ajax.prototype = {
  /**
   * HTTP᥽åɤ򥻥å
   *
   * @param string GET or POST
   */
  setMethod: function(method)
  {
    this.method = method;
  },
  /**
   * ƱƱ̿򥻥å
   *
   * @param bool true: Ʊfalse: Ʊ
   */
  setAsync: function(async)
  {
    this.async = (async == false) ? false : true;
  },
  /**
   * ꥯΥ٥ȴؿ򥻥å
   *
   * @param object ꥯΥ٥ȴؿ
   */
  setLoadingFunc: function(loadingFunc)
  {
    this.loadingFunc = loadingFunc;
  },
  /**
   * ꥯȸΥ٥ȴؿ򥻥å
   *
   * @param object ꥯȸΥ٥ȴؿ
   */
  setLoadedFunc: function(loadedFunc)
  {
    this.loadedFunc = loadedFunc;
  },
  /**
   * HTTPꥯȥѥ᡼򥻥å
   *
   * @param string 
   * @param string 
   */
  setParameter: function(key, value)
  {
    this.parameters[key] = value;
  },
  /**
   * XMLHttp֥Ȥ
   *
   * @return object XMLHttp֥
   */
  getXMLHttpObject: function()
  {
    var request = null;
    if (window.ActiveXObject) {
      try {
        request = new ActiveXObject("Msxml2.XMLHTTP");
      } catch(e) {
        try {
          request = new ActiveXObject("Microsoft.XMLHTTP");
        } catch(e) {
          request = null;
        }
      }
    } else if (window.XMLHttpRequest) {
      request = new XMLHttpRequest();
      if (request.overrideMimeType) {
        request.overrideMimeType('text/plain');
      }
    }

    if (request == null) {
      alert("XMLHTTP object not found");
    }

    return request;
  },
  /**
   * HTTPꥯȤ
   * 
   * readyState
   *   0: UNINITIALIZED openƤФƤʤ 
   *   1: LOADING       sendƤФƤʤ 
   *   2: LOADED        responseƤʤ 
   *   3: INTERACTIVE   ʬŪ˱ 
   *   4: COMPLETED     λ 
   *
   * @param string ꥯURL
   */
  sendRequest: function(url)
  {
    if (this.loadedFunc == null) {
      alert('undefined Loaded Function');
      return;
    }

    var self = this;

    var parameter = '';
    for (var key in self.parameters) {
      if (parameter != '') {
        parameter += '&';
      }
      parameter += encodeURIComponent(key) + "=" + encodeURIComponent(self.parameters[key]);
    }

    var loadedFunc  = self.loadedFunc;
    var loadingFunc = self.loadingFunc;

    if (loadingFunc && (typeof(loadingFunc) == "string")) {
      if (!loadingFunc.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
        alert("Invalid Loading Function name");
      }
      loadingFunc = eval('(' + loadingFunc + ')');
    }

    if ((url.substr(0, 7) == "http://")  ||
        (url.substr(0, 8) == "https://") ||
        (url.substr(0, 2) == "//")) {
      // for JSONP
      if (typeof(loadedFunc) != "string") {
        alert("Invalid Loaded Function. JSONP is string only.");
        return;
      } else if (!loadedFunc.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
        alert("Invalid Loaded Function name");
      }

      if (self.method == 'POST') {
        var id = '__syl_ajax_id';
        var i = 0;
        while (true) {
          if (!document.getElementById(id + i)) {
            id = id + i;
            break;
          }
        }

        var div = document.createElement('div');
        div.innerHTML = '<iframe src="javascript:false;" style="display:none" id="' + id + '" name="' + id + '"></iframe>';
        document.lastChild.appendChild(div);

        var form = document.createElement('form');
        form.method = self.method;
        form.target = id;
        form.action = url;
        form.name   = id + "_form";
        form.id     = id + "_form";

        for (var key in self.parameters) {
          var input   = document.createElement("input");
          input.type  = "hidden";
          input.name  = key;
          input.value = self.parameters[key];
          form.appendChild(input);
        }
        // Хåؿ
        var input   = document.createElement("input");
        input.type  = "hidden";
        input.name  = self.callback_parameter_name;
        input.value = loadedFunc;
        form.appendChild(input);

        // HTMLͭ
        document.lastChild.appendChild(form);
        // POST
        document.forms[id + "_form"].submit();
      } else {
        if (parameter != '') {
          parameter += '&';
        }
        // Хåؿ
        parameter += self.callback_parameter_name + "=" + encodeURIComponent(loadedFunc);
        // HTML
        var script     = document.createElement('script');
        script.type    = "text/javascript";
        script.charset = "UTF-8";
        script.src     = url + '?' + parameter;
        // HTMLͭ
        document.lastChild.appendChild(script);
      }
    } else {
      if (typeof(loadedFunc) == "string") {
        if (!loadedFunc.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
          alert("Invalid Loaded Function name");
        }
        loadedFunc = eval('(' + loadedFunc + ')');
      }

      var request = self.request;

      // for JSON
      request.onreadystatechange = function()
      {
        switch (request.readyState) {
        case 4:
          switch (request.status) {
          case 200:
            var data;
            if (request.getResponseHeader('Content-Type').match(/json/i)) {
                data = eval('(' + request.responseText + ')');
            } else {
                data = request.responseText;
            }
            if (typeof(loadedFunc) == "function") {
                loadedFunc(data);
            }
            break;

          case 301:
          case 306: // 301 ϥ֥饦٥ǥ쥯Ȥ뤿306
            var url = request.getResponseHeader('Location');
            if (url) {
              window.location.href = url;
            } else {
              alert('301 Moved Permanently. But Nothing Location header');
              if (typeof(loadedFunc) == "function") {
                loadedFunc(false);
              }
            }
            break;

          case 500:
            alert('500 Internal Server Error: \n' + request.responseText);
            break;

          default:
            alert('Response Error: ' + request.status + ' ' + request.statusText);
          }
          break;

        default:
          if (typeof(loadingFunc) == "function") {
            loadingFunc();
          }
          break;
        }
      };

      // ॢ
      var timer = setInterval(function()
      {
        self.cancelRequest();
        clearInterval(timer);
      },
      self.timeout);

      if (self.method == 'POST') {
        request.open(self.method, url, self.async);
        request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
        request.send(parameter);
      } else {
        request.open(self.method, url + '?' + parameter, self.async);
        request.send(null);
      }
    }
  },
  /**
   * ꥯȤ򥭥󥻥
   *
   */
  cancelRequest: function()
  {
    if (typeof(this.request) == "object") {
      if (this.request.readyState == 0 || this.request.readyState == 4) {
        return;
      }
      this.request.abort();
    }
  }
}

/**
 * SyL_Ajaxꥯȥ饹
 *
 */
var SyL_AjaxRequest = {
  sendSyncGet: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {'loaded': loadedFunc, 'loading': loadingFunc, 'async': false, 'method': 'GET', 'parameters': parameters});
  },
  sendSyncPost: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {'loaded': loadedFunc, 'loading': loadingFunc, 'async': false, 'method': 'POST', 'parameters': parameters});
  },
  sendAsyncGet: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {'loaded': loadedFunc, 'loading': loadingFunc, 'async': true, 'method': 'GET', 'parameters': parameters});
  },
  sendAsyncPost: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {'loaded': loadedFunc, 'loading': loadingFunc, 'async': true, 'method': 'POST', 'parameters': parameters});
  },

  /**
   * {
   *   loaded  : (value)
   *   loading : (value)
   *   method  : (value)
   *   async   : (value)
   * }
   */
  send: function(url, action, arg)
  {
    if (!url) {
      alert('url undefined');
      return;
    }

    var action_key = '<?= $action_key ?>';
    var ajax = new SyL_Ajax();
    if (action) {
        ajax.setParameter(action_key, action);
    }
    if (typeof(arg) == "object") {
      if (arg.loaded) {
        ajax.setLoadedFunc(arg.loaded);
      }
      if (arg.loading) {
        ajax.setLoadingFunc(arg.loading);
      }
      if (arg.method) {
        ajax.setMethod(arg.method);
      }
      if ((arg.async != "undefined") && (arg.async != null)) {
        ajax.setAsync(arg.async);
      }
      if (arg.parameters) {
        for (var i in arg.parameters) {
          ajax.setParameter(i, arg.parameters[i]);
        }
      }
    }
    ajax.sendRequest(url);
  }
}

