<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan -  - ʥꥹѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 *  - ʥꥹ
 *   http://developer.yahoo.co.jp/auctions/rest/categoryleaf/V1/categoryleaf.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionCategoryLeafResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ˰פܤξʡʥˤǡΥޥå꡼
     *
     * @access private
     * @var int
     */
     var $total_f_auctions = null;
    /**
     * ˰פʡʥˤ 
     *
     * @access private
     * @var int
     */
    var $total_auctions = null;
    /**
     * ˰פڡ
     *
     * @access private
     * @var int
     */
    var $total_page = null;
    /**
     * ߤΥڡֹ
     *
     * @access private
     * @var string
     */
    var $cur_page = null;
    /**
     * ʥꥹȡʥƥ꡼աˤΥѥ
     *
     * @access private
     * @var string
     */
    var $category_path = null;
    /**
     * ʡʥ˾
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/AuctionCategoryLeaf':
            if (isset($attribute['totalFAuctions'])) {
                $this->total_f_auctions = $attribute['totalFAuctions'];
            }
            if (isset($attribute['totalAuctions'])) {
                $this->total_auctions = $attribute['totalAuctions'];
            }
            if (isset($attribute['totalPage'])) {
                $this->total_page = $attribute['totalPage'];
            }
            if (isset($attribute['curPage'])) {
                $this->cur_page = $attribute['curPage'];
            }
            if (isset($attribute['categoryPath'])) {
                $this->category_path = $attribute['categoryPath'];
            }
            break;

        // ʡʥ˾
        case '/AuctionCategoryLeaf/item': $item_i++; break;
        // ʡʥˤID
        case '/AuctionCategoryLeaf/item/auctionID': $this->items[$item_i]['auctionID'] = $text; break;
        // ʡʥˤΥȥ
        case '/AuctionCategoryLeaf/item/title': $this->items[$item_i]['title'] = $text; break;
        // ʼԤ˴ؤ
        case '/AuctionCategoryLeaf/item/seller': $this->items[$item_i]['seller'] = array(); break;
        // ʼԤYahoo! JAPAN ID
        case '/AuctionCategoryLeaf/item/seller/id': $this->items[$item_i]['seller']['id'] = $text; break;
        // ʥꥹȤꥯURL
        case '/AuctionCategoryLeaf/item/seller/itemlist': $this->items[$item_i]['seller']['itemlist'] = $text; break;
        // ʼԤɾΥڡURL
        case '/AuctionCategoryLeaf/item/seller/rating': $this->items[$item_i]['seller']['rating'] = $text; break;
        // ʾܺ١ʥ˥ڡURL
        case '/AuctionCategoryLeaf/item/url': $this->items[$item_i]['url'] = $text; break;
        // ʥͥˤURL
        case '/AuctionCategoryLeaf/item/img': $this->items[$item_i]['img'] = $text; break;
        // ߲
        case '/AuctionCategoryLeaf/item/price': $this->items[$item_i]['price'] = $text; break;
        // ߤ
        case '/AuctionCategoryLeaf/item/bids': $this->items[$item_i]['bids'] = $text; break;
        // νλ
        case '/AuctionCategoryLeaf/item/endtime': $this->items[$item_i]['endtime'] = $text; break;
        // ˾
        case '/AuctionCategoryLeaf/item/bidorbuy': $this->items[$item_i]['bidorbuy'] = $text; break;
        // ʤ̵ͭ
        case '/AuctionCategoryLeaf/item/reserved': $this->items[$item_i]['reserved'] = $text; break;
        // ʡʥˤΥץ
        case '/AuctionCategoryLeaf/item/option': $this->items[$item_i]['option'] = array(); break;
        // ʡʥˤΥץ: newץURL
        case '/AuctionCategoryLeaf/item/option/new': $this->items[$item_i]['option']['new'] = $text; break;
        // ʡʥˤΥץ: storeץURL
        case '/AuctionCategoryLeaf/item/option/store': $this->items[$item_i]['option']['store'] = $text; break;
        // ʡʥˤΥץ: ִѤߡץURL
        case '/AuctionCategoryLeaf/item/option/check': $this->items[$item_i]['option']['check'] = $text; break;
        // ʡʥˤΥץ: ָץURL
        case '/AuctionCategoryLeaf/item/option/public': $this->items[$item_i]['option']['public'] = $text; break;
        // ʡʥˤΥץ: ̵ץURL
        case '/AuctionCategoryLeaf/item/option/freeshipping': $this->items[$item_i]['option']['freeshipping'] = $text; break;
        // ʡʥˤΥץ: ּѥӥץURL
        case '/AuctionCategoryLeaf/item/option/escrow': $this->items[$item_i]['option']['escrow'] = $text; break;
        // ʡʥˤΥץ: £ʡץURL
        case '/AuctionCategoryLeaf/item/option/wrappingicon': $this->items[$item_i]['option']['wrappingicon'] = $text; break;
        // ʡʥˤΥץ: ¨ץURL
        case '/AuctionCategoryLeaf/item/option/buynow': $this->items[$item_i]['option']['buynow'] = $text; break;
        // ʡʥˤΥץ: Yahoo!󤿤ѡץURL
        case '/AuctionCategoryLeaf/item/option/easypayment': $this->items[$item_i]['option']['easypayment'] = $text; break;
        // ʡʥˤΥץ: ץURL
        case '/AuctionCategoryLeaf/item/option/largeimg': $this->items[$item_i]['option']['largeimg'] = $text; break;
        // ʡʥˤΥץ: ΩץURL
        case '/AuctionCategoryLeaf/item/option/gift_icon': $this->items[$item_i]['option']['gift_icon'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ˰פܤξʡʥˤǡΥޥå꡼
     *
     * @access public
     * @return int ˰פܤξʡʥˤǡΥޥå꡼
     */
    function getTotalFAuctions()
    {
        return $this->total_f_auctions;
    }

    /**
     * ˰פʡʥˤ
     *
     * @access public
     * @return int ˰פʡʥˤ
     */
    function getTotalAuctions()
    {
        return $this->total_auctions;
    }

    /**
     * ˰פڡ
     *
     * @access public
     * @return int ˰פڡ
     */
    function getTotalPage()
    {
        return $this->total_page;
    }

    /**
     * ߤΥڡֹ
     *
     * @access public
     * @return int ߤΥڡֹ
     */
    function getCurPage()
    {
        return $this->cur_page;
    }

    /**
     * ʥꥹȡʥƥ꡼աˤΥѥ
     *
     * @access public
     * @return string ʥꥹȡʥƥ꡼աˤΥѥ
     */
    function getCategoryPath()
    {
        return $this->category_path;
    }

    /**
     * ʡʥ˾
     *
     * @access public
     * @return array ʡʥ˾
     */
    function getItems()
    {
        return $this->items;
    }
}

?>
