<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailRequest.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan -ߤʤθ ܺWebӥ
 */
require_once 'SyL_WebServiceMinnaCertCertDetailResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ߤʤθ ꥹWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ߤʤθ ܺWebӥ
 *   http://developer.yahoo.co.jp/minna_cert/certdetail/V1/certdetail.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailRequest.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMinnaCertCertDetailRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'api.cert.yahoo.co.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/MinnaCertWebService/V1/certDetail';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMinnaCertCertDetailResponse';

    /**
     * ID򥻥åȤ
     *
     * @access public
     * @param int ID
     */
    function setCert_id($cert_id)
    {
        if (preg_match('/^\d+$/', $cert_id)) {
            parent::set('cert_id', $cert_id);
        } else {
            trigger_error("[SyL error] Invalid `cert_id' property ({$cert_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ե饰򥻥åȤ
     *
     * @access public
     * @param int ե饰
     */
    function setGet_q($get_q)
    {
        switch ((string)$get_q) {
        case '0': // ʤ
        case '1': // 
        case '2': // +Ȳ
            parent::set('get_q', $get_q);
            break;
        default:
            trigger_error("[SyL error] Invalid `get_q' property ({$get_q}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֹ򥻥åȤ
     *
     * @access public
     * @param int ֹ
     */
    function setOrder_number($order_number)
    {
        switch ((string)$order_number) {
        case '0': // ٤Ƥ
        case '1': // ʲбֹξ
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case '10':
            parent::set('order_number', $order_number);
            break;
        default:
            trigger_error("[SyL error] Invalid `order_number' property ({$order_number}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
