<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 󥯥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Action
{
    /**
     * ХǡưȽ
     * 
     * @access protected
     * @var bool
     */
    var $validation_trigger = false;
    /**
     * Хǡ
     * 
     * @access protected
     * @var array or string
     */
    var $validation_config = null;
    /**
     * ե̾
     * 
     * @access protected
     * @var string
     */
    var $action_form_class = '';
    /**
     * 顼å
     * 
     * @access protected
     * @var array
     */
    var $error_messages = array();

    /**
     * ᥽åɼ¹˼¹Ԥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function preExecute(&$data, &$context)
    {
    }

    /**
     * ڼ¹ԥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function validate(&$data, &$context)
    {
        if ($this->validation_trigger) {
            // եफХǡ
            if ($this->action_form_class) {
                $form =& $this->getActionForm($data);
                if (!$form->validate()) {
                    $this->validateError($form->getErrorMessageAll());
                }
            } else {
                // ͤХǡ
                if (is_array($this->validation_config)) {
                    // Хǡޥ͡㥤󥯥롼
                    include_once SYL_INCLUDE_DIR . '/lib/SyL_ValidationManager.php';
                    // Хǡޥ͡㥪֥Ⱥ
                    $manager =& new SyL_ValidationManager();
                    foreach ($this->validation_config as $name => $values) {
                        if (isset($values['validate']) && is_array($values['validate'])) {
                            $validators =& SyL_Validators::create();
                            foreach ($values['validate'] as $validation_name => $validations) {
                                $options = isset($validations['parameters']) ? $validations['parameters'] : array();
                                $validators->add(SyL_Validator::create($validation_name, $validations['message'], $options));
                            }
                            $display_name = isset($values['name']) ? $values['name'] : $name;
                            $manager->add($validators, $data->get($name), $name, $display_name);
                        }
                    }
                    // ХǡȽ
                    if (!$manager->execute()) {
                        $this->validateError($manager->getErrorMessageAll());
                    }

                // ե뤫Хǡ
                } else if (is_string($this->validation_config)) {
                    $file = SYL_APP_DIR . '/config/' . $this->validation_config;
                    if (!is_file($file)) {
                        $file1 = SYL_PROJECT_DIR . '/config/' . $this->validation_config;
                        if (!is_file($file1)) {
                            trigger_error("[SyL error] Validation config file not found ({$file}, {$file1})", E_USER_ERROR);
                        }
                        $file = $file1;
                    }
                    // Хǡޥ͡
                    include_once SYL_INCLUDE_DIR . '/lib/SyL_ValidationManager.php';
                    $manager =& new SyL_ValidationManager();
                    // Хǡ
                    $config =& SyL_ValidationManager::getConfig($file);
                    // ХǡȽ
                    if (!$manager->executeConfig($config, $data->gets())) {
                        $this->validateError($manager->getErrorMessageAll());
                    }
                }
            }
        }
    }

    /**
     * ¹ԥǥեȥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
    }

    /**
     * ᥽åɼ¹Ը˼¹Ԥ᥽å
     * 
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function postExecute(&$data, &$context)
    {
    }


    // -----------------------------------------------------
    // ХǡϢ᥽å
    // -----------------------------------------------------

    /**
     * ڥ顼˼¹Ԥ᥽å
     *
     * @access protected
     * @param array 顼å
     */
    function validateError($error_messages)
    {
        $this->error_messages = $error_messages;
    }

    /**
     * 顼Ƚ
     *
     * @access public
     * @return bool true: false: 顼
     */
    function isValid()
    {
        return (count($this->error_messages) == 0);
    }


    // -----------------------------------------------------
    // եϢ̥᥽å
    // -----------------------------------------------------

    /**
     * ե४֥Ȥ
     *
     * @access protected
     * @param object ǡ֥
     * @param bool ɽե饰
     * @param string ե९饹̾
     * @return object ե४֥
     */
    function &getActionForm(&$data, $first=false, $action_form_class='')
    {
        static $form = array();
        if (!$action_form_class) {
            $action_form_class = $this->action_form_class;
        }
        if (!isset($form[$action_form_class])) {
            // ե
            include_once SYL_INCLUDE_DIR . '/framework/SyL_ActionForm.php';
            $form[$action_form_class] =& SyL_ActionForm::factory($action_form_class);
            // ǡ֥ȥå
            $form[$action_form_class]->registerInput($data);
            // ե๽
            $form[$action_form_class]->build($first);
        }
        return $form[$action_form_class];
    }
}

?>
