<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowFin.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * եλ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowFin.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowFin extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'fin';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowFin()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * λɽե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        if ($form->getStructConfig('view_fin') === false) {
            SyL_Response::redirect($this->getUrl('lst'));
        }

        switch ($data->get('adm_action')) {
        case 'new':
        case 'upd':
        case 'del':
            $data->set('adm_action', $data->get('adm_action'));
            break;
        default:
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // Ϣǡ󥯤ѥ
        list($pu, $cu, $nu) = $this->getLocations($data->get('adm_u'));
        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_dir', dirname($this->getScriptName()));
        $data->set('url_lst_u', $this->getUrl('lst', $pu));

        // Ϣǡ󥯤ѥ
        $data->set('cu', $cu);
    }

}

?>
