<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCϥ顼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorXmlrpc extends SyL_Error
{
    /**
     * 404 Not Found ɽ
     *
     * @access public
     */
    function forward404Detail()
    {
        SyL_Loggers::notice("404 Not Found");
        SyL_Response::setStatusHeader('404');
        
        echo "404 Not Found";
    }

    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
        if (!ini_get('display_errors')) {
            return;
        }

        // XMLRPCꥯȥѡ饹
        include_once SYL_INCLUDE_DIR . '/lib/Xml/Rpc/SyL_XmlRpcBuilderServer.php';

        $builder =& new SyL_XmlRpcBuilderServer();
        // 顼No򥻥å
        $builder->setErrorCode($this->controller->getErrorNo());
        // 顼å򥻥å
        $builder->setErrorMessage(implode($this->eol, $error_messages));
        // 󥳡ǥ󥰤򥻥å
        $builder->setEncoding(SYL_ENCODE_XMLRPC);

         // ƥĥ
        $content_type = 'text/xml; charset=' . SYL_ENCODE_XMLRPC;
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::singleton();
        $response->display($builder->build());
    }

    /**
     * ¸¾
     *
     * @access protected
     * @return string ¾
     */
    function extraLog()
    {
        $error_message  = '';
        if (isset($_SERVER['REQUEST_METHOD']))  $error_message .= 'REQUEST_METHOD: ' . $_SERVER['REQUEST_METHOD']  . $this->eol;
        if (isset($_SERVER['REQUEST_URI']))     $error_message .= 'REQUEST_URI: '    . $_SERVER['REQUEST_URI']     . $this->eol;
        if (isset($_SERVER['HTTP_REFERER']))    $error_message .= 'REFERRER: '       . $_SERVER['HTTP_REFERER']    . $this->eol;
        if (isset($_SERVER['HTTP_USER_AGENT'])) $error_message .= 'USER_AGENT: '     . $_SERVER['HTTP_USER_AGENT'] . $this->eol;
        $error_message .= 'GET : '  . print_r($_GET, true);
        $error_message .= 'POST : ' . print_r($_POST, true);
        return $error_message;
    }

}

?>
