<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeRequest.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Yahoo!η:ƥĥ꡼ѡ
 */
require_once 'SyL_WebServiceChiebukuroCategoryTreeResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - Yahoo!η:ƥĥ꡼ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * Yahoo!η:ƥĥ꡼
 *   http://developer.yahoo.co.jp/chiebukuro/categoryTree/V1/categoryTree.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeRequest.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceChiebukuroCategoryTreeRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'chiebukuro.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/Chiebukuro/V1/categoryTree';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceChiebukuroCategoryTreeResponse';

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param int ƥID
     */
    function setCategoryid($categoryid)
    {
        if (preg_match('/^\d+$/', $categoryid)) {
            parent::set('categoryid', $categoryid);
        } else {
            trigger_error("[SyL error] Invalid `categoryid' property ({$categoryid}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
