<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebSearchResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ָѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ָ
 *   http://developer.yahoo.co.jp/search/web/V1/webSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebSearchResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceSearchWebSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        case '/ResultSet/Result': $i++; break;
        // ڡΥȥ
        case '/ResultSet/Result/Title': $this->results[$i]['Title'] = $text; break;
        // ڡ˴Ϣƥȥޥ꡼
        case '/ResultSet/Result/Summary': $this->results[$i]['Summary'] = $text; break;
        // ڡURL
        case '/ResultSet/Result/Url': $this->results[$i]['Url'] = $text; break;
        // ڡΥURL
        case '/ResultSet/Result/ClickUrl': $this->results[$i]['ClickUrl'] = $text; break;
        // ڡǸ˽줿
        case '/ResultSet/Result/ModificationDate': $this->results[$i]['ModificationDate'] = $text; break;
        // ڡMIME
        case '/ResultSet/Result/MimeType': $this->results[$i]['MimeType'] = $text; break;
        // 㥷
        case '/ResultSet/Result/Cache': $this->results[$i]['Cache'] = array(); break;
        // 㥷̤URL
        case '/ResultSet/Result/Cache/Url': $this->results[$i]['Cache']['Url'] = $text; break;
        // 㥷̤Υ
        case '/ResultSet/Result/Cache/Size': $this->results[$i]['Cache']['Size'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
