<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.4 2008/07/27 14:53:10 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץȺ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.4 2008/07/27 14:53:10 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index extends AppAction
{
    var $c_action; // 󥸥
    var $c_application; // 󥸥
    var $c_controller; // 󥸥
    var $c_template; // 󥸥
    var $c_project; // 󥸥

    /**
     * ᥤ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        switch (strtolower($data->get(1))) {
        case 'project':
        case 'pro':
            include_once 'Project.php';
            $obj =& new Project();
            $obj->c_action      =& $this->c_action;
            $obj->c_application =& $this->c_application;
            $obj->c_controller  =& $this->c_controller;
            $obj->c_template    =& $this->c_template;
            $obj->c_project     =& $this->c_project;
            $obj->execute($data, $context);
            break;
        case 'application':
        case 'app':
            include_once 'Application.php';
            $obj =& new Application();
            $obj->c_action      =& $this->c_action;
            $obj->c_application =& $this->c_application;
            $obj->c_controller  =& $this->c_controller;
            $obj->c_template    =& $this->c_template;
            $obj->execute($data, $context);
            break;
        case 'controller':
        case 'con':
            include_once 'Controller.php';
            $obj =& new Controller();
            $obj->c_controller =& $this->c_controller;
            $obj->execute($data, $context);
            break;
        case 'action':
        case 'act':
            include_once 'Action.php';
            $obj =& new Action();
            $obj->c_action =& $this->c_action;
            $obj->execute($data, $context);
            break;
        case 'template':
        case 'tem':
            include_once 'Template.php';
            $obj =& new Template();
            $obj->c_template =& $this->c_template;
            $obj->execute($data, $context);
            break;
        default:
            // С󥳥ޥ
            if ($data->is('h') || $data->is('help')) {
                $this->displayHelp($cmd, $data->get(0));
            // إץޥ
            } else if ($data->is('v') || $data->is('version')) {
                $this->displayVersion($cmd, $data->get(0));
            } else {
                $this->displayDefault($cmd, $data->get(0));
            }
        }
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} project [or pro] -d <dir> -w <name> [-c <file>] [-s <dir>]
  php {$file} application [or app] -d <dir> -w <name> [-c <file>]
  php {$file} controller [or con] -d <dir> -w <name> -c <file>
  php {$file} action [or act] -d <dir> -w <name> -a <name>
  php {$file} template [or tem] -d <dir> -w <name> -t <name>
  php {$file} [option]

Options:
  -d <dir>  project directory
  -w <name> application name
  -c <file> front controller file
  -a <name> action file (path from action directory)
  -t <name> template file (path from template directory)
  -s <dir>  Smarty directory
  -h        show this help, then exit
  -v        output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
